/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class PatternCache {
    private static final Logger log = Logger.getLogger(PatternCache.class);
    private static int CAPACITY = 1000;
    private static final Map<String, Pattern> cache = new LinkedHashMap<String, Pattern>(CAPACITY, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
            boolean over;
            boolean bl = over = this.size() > CAPACITY;
            if (over) {
                log.debug("\u6b63\u898f\u8868\u73fe\u30ad\u30e3\u30c3\u30b7\u30e5\u6700\u5927\u5bb9\u91cf %d \u8d85\u904e\u306e\u305f\u3081\u53e4\u3044\u8981\u7d20\u3092\u524a\u9664\u3057\u307e\u3057\u305f\u3002%s", CAPACITY, eldest.getKey());
            }
            return over;
        }
    };

    public static Pattern get(String regex) {
        Pattern pat = cache.get(regex);
        if (pat == null) {
            pat = Pattern.compile(regex);
            cache.put(regex, pat);
        }
        return pat;
    }

    private PatternCache() {
    }
}

