/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.mergedoc.org.apache.commons.io.IOUtils;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

public class FileLogger
extends Logger {
    public static final String LOG_FILE_NAME = "pleiades.log.file.name";
    private static final Map<String, PrintStream> outMap = new HashMap<String, PrintStream>();
    protected String logFileName = System.getProperty("pleiades.log.file.name");

    public static void close() {
        for (PrintStream out : outMap.values()) {
            IOUtils.closeQuietly(out);
        }
        outMap.clear();
    }

    protected FileLogger(String category) {
        super(category);
        if (this.getOut() != null) {
            return;
        }
        try {
            File logFile = new File(this.logFileName);
            logFile.getParentFile().mkdirs();
            logFile.delete();
            PrintStream out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(logFile)), true, "UTF-8");
            outMap.put(this.logFileName, out);
        }
        catch (IOException e) {
            throw new RuntimeException("\u30d7\u30ed\u30d1\u30c6\u30a3\u306b\u6307\u5b9a\u3055\u308c\u305f pleiades.log.file.name=" + this.logFileName + " \u304c\u4e0d\u6b63\u3067\u3059\u3002", e);
        }
    }

    @Override
    protected PrintStream getOut() {
        return outMap.get(this.logFileName);
    }

    @Override
    public void fatal(Throwable e, String message, Object ... args) {
        super.fatal(e, message, args);
        System.err.println(this.format(message, args));
        if (e != null) {
            System.err.println(e);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.logFileName;
    }
}

