package jp.sourceforge.masme.action;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.service.ReflectTargetService;
import jp.sourceforge.masme.util.impl.SimpleDateUtils;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class ReflectOkAction extends Action {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        DynaValidatorForm dynaForm = (DynaValidatorForm) form;
        Class<WorkEntity> targetClass = (Class<WorkEntity>) request
                .getSession().getAttribute("targetClass");

        String reflectDateStr = (String) dynaForm.get("reflectDate");
        Date reflectDate = null;
        if (!StringUtils.isEmpty(reflectDateStr)) {
            reflectDate = SimpleDateUtils.stringToDate(reflectDateStr);
        }

        service.reflect(targetClass, reflectDate);

        return mapping.findForward("success");
    }

    /** このアクションで利用するサービス */
    private ReflectTargetService service;

    /**
     * @param service
     *            このアクションで利用するサービス
     */
    public void setService(ReflectTargetService service) {
        this.service = service;
    }
}
