package jp.sourceforge.masme.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.service.LoadTargetService;
import jp.sourceforge.masme.target.MaintenanceTarget;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class EditInitAction extends Action {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        DynaValidatorForm dynaForm = (DynaValidatorForm) form;
        String id = (String) dynaForm.get("id");

        Class<WorkEntity> targetClass = (Class<WorkEntity>) request
                .getSession().getAttribute("targetClass");
        MaintenanceTarget maintenanceTarget = service.get(targetClass, id);
        request.getSession().setAttribute("maintenanceTarget",
                maintenanceTarget);

        return mapping.findForward("success");
    }

    /** このアクションで利用するサービス */
    private LoadTargetService service;

    /**
     * @param service
     *            このアクションで利用するサービス
     */
    public void setService(LoadTargetService service) {
        this.service = service;
    }
}
