package jp.sourceforge.masme.samples.standalone.test;

import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.samples.standalone.entity.CourseWork;
import jp.sourceforge.masme.samples.standalone.entity.StudentWork;
import jp.sourceforge.masme.samples.standalone.entity.Subject;
import jp.sourceforge.masme.samples.standalone.entity.TeacherWork;
import jp.sourceforge.masme.service.ConfirmEntityService;
import jp.sourceforge.masme.service.EditEntityService;
import jp.sourceforge.masme.util.impl.SimpleDateUtils;

import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

public class AddTest extends AbstractTransactionalDataSourceSpringContextTests {

    private EditEntityService<CourseWork> editCourse;
    private ConfirmEntityService<CourseWork> confirmCourse;
    private EditEntityService<TeacherWork> editTeacher;
    private ConfirmEntityService<TeacherWork> confirmTeacher;
    private EditEntityService<StudentWork> editStudent;
    private ConfirmEntityService<StudentWork> confirmStudent;
    public AddTest() {
        super.setAutowireMode(AUTOWIRE_BY_NAME);
    }

    public void test_edit_ng() throws Exception {
        TeacherWork suzukiTeacher = new TeacherWork(1, "Suzuki");
        suzukiTeacher.getSubjects().add(Subject.English);
        editTeacher.add(suzukiTeacher);
        CourseWork english1 = new CourseWork(1, "English-1", Subject.English);
        try {
            editCourse.add(english1);
            fail();
        } catch (MasmenValidateException e) {

        }
    }
    public void test_add_ok() throws Exception {
        TeacherWork suzukiTeacher = new TeacherWork(1, "Suzuki");
        suzukiTeacher.getSubjects().add(Subject.English);
        editTeacher.add(suzukiTeacher);
        CourseWork english1 = new CourseWork(1, "English-1", Subject.English);
        english1.setTeacherWork(suzukiTeacher);
        editCourse.add(english1);

        confirmTeacher.changeReflectDate(suzukiTeacher, SimpleDateUtils
                .stringToDate("2008/01/01"));
        confirmTeacher.confirm(suzukiTeacher);
        confirmCourse.changeReflectDate(english1, SimpleDateUtils
                .stringToDate("2008/01/01"));
        confirmCourse.confirm(english1);
    }
    @Override
    protected String getConfigPath() {
        return "AddTest.xml";
    }

    public void setConfirmCourse(ConfirmEntityService<CourseWork> confirmCourse) {
        this.confirmCourse = confirmCourse;
    }

    public void setConfirmStudent(
            ConfirmEntityService<StudentWork> confirmStudent) {
        this.confirmStudent = confirmStudent;
    }

    public void setConfirmTeacher(
            ConfirmEntityService<TeacherWork> confirmTeacher) {
        this.confirmTeacher = confirmTeacher;
    }

    public void setEditCourse(EditEntityService<CourseWork> editCourse) {
        this.editCourse = editCourse;
    }

    public void setEditStudent(EditEntityService<StudentWork> editStudent) {
        this.editStudent = editStudent;
    }

    public void setEditTeacher(EditEntityService<TeacherWork> editTeacher) {
        this.editTeacher = editTeacher;
    }

}
