package jp.sourceforge.masme.test.entity;

import java.io.Serializable;

import javax.persistence.Id;

import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.annotation.MaintenanceTargetProperty;
import jp.sourceforge.masme.annotation.ReferenceTargetProperty;


import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/** @author Hibernate CodeGenerator */
public abstract class AbstractCustomer {

    private String id;
    private String name;
    private String state;
    private Company company;
    private Company nullableCompany;

    @Id
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setId(Serializable id) {
        setId((String) id);
    }

    @MaintenanceTargetProperty
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @MaintenanceTargetProperty
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", getId()).append("name",
                getName()).append("state", getState()).toString();
    }

    public boolean equals(Object other) {
        if ((this == other))
            return true;
        if (!(other instanceof AbstractCustomer))
            return false;
        AbstractCustomer castOther = (AbstractCustomer) other;
        return new EqualsBuilder().append(this.getId(), castOther.getId())
                .isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    @MaintenanceTargetProperty(referenceTarget = { @ReferenceTargetProperty(workPropertyName = "companyWork", referencePropertyName = "customers", workReferencePropertyName = "customerWorks", validationMethodName = "validateForCompany") }

    )
    public Company getCompany() {
        return company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }
    public void validateForCompany(AbstractCompany company) {
        System.out.println("testtest" + this);
        if (company==null) {
            throw new MasmenValidateException("整合性失敗"+company);
        }
        if (this.getName().equals(company.getName())) {
            throw new MasmenValidateException("整合性失敗"+company);
        }
    }
    public void validateForNullableCompany(AbstractCompany company) {
        System.out.println("testtest" + this);
        if (company==null) {
            return;
        }
        if (this.getName().equals(company.getName())) {
            throw new MasmenValidateException("整合性失敗"+company);
        }
    }

    @MaintenanceTargetProperty(referenceTarget = { @ReferenceTargetProperty(workPropertyName = "nullableCompanyWork", referencePropertyName = "nullableCustomers", workReferencePropertyName = "nullableCustomerWorks", validationMethodName = "validateForNullableCompany") }

    )
    public Company getNullableCompany() {
        return nullableCompany;
    }

    public void setNullableCompany(Company nullableCompany) {
        this.nullableCompany = nullableCompany;
    }

}
