package jp.sourceforge.masme.dao;

import java.util.Date;

import jp.sourceforge.masme.dao.impl.MaintenanceTargetDaoImpl;
import jp.sourceforge.masme.entity.WorkInfo;
import jp.sourceforge.masme.test.entity.CompanyWork;
import jp.sourceforge.masme.test.entity.CustomerWork;

import org.hibernate.SessionFactory;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

public class MaintenanceTargetDaoTest extends
        AbstractTransactionalDataSourceSpringContextTests {

    private MaintenanceTargetDaoImpl dao;
    private Class targetClass = CustomerWork.class;
    private SessionFactory sessionFactory;

    @Override
    protected String getConfigPath() {
        return "/jp/sourceforge/masme/dao/MaintenanceTargetDaoTest.xml";
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
    }

    public void testLoadAll() {
        CompanyWork c = createCompanyWork("1", "toyota");
        dao.save(c);
        sessionFactory.getCurrentSession().flush();
        dao.save(createCompanyWork("2", "nissan"));
        sessionFactory.getCurrentSession().flush();
        dao.save(createCustomerWork("1", "name1", c));
        sessionFactory.getCurrentSession().flush();
        dao.save(createCustomerWork("2", "name2", c));
        sessionFactory.getCurrentSession().flush();
        dao.save(createCustomerWork("3", "name3", c));
        sessionFactory.getCurrentSession().flush();
        dao.loadAll(targetClass);
    }

    public void testLoadEditAll() {
        dao.loadEditAll(targetClass);
    }

    public void setMaintenanceTargetDaoImpl(MaintenanceTargetDaoImpl dao) {
        this.dao = dao;
    }

    public static CustomerWork createCustomerWork(String id, String name,
            CompanyWork companyWork) {
        CustomerWork work = new CustomerWork();
        work.setId(id);
        work.setName(name);
        work.setState("JP");
        work.setCompanyWork(companyWork);
        if (companyWork != null) {
            companyWork.getCustomerWorks().add(work);
        }
        work.setWorkInfo(new WorkInfo());
        work.getWorkInfo().setReflectedTimestamp(new Date());
        work.getWorkInfo().setScheduledDate(new Date());
        return work;
    }

    public static CompanyWork createCompanyWork(String id, String name) {
        CompanyWork work = new CompanyWork();
        work.setId(id);
        work.setName(name);
        work.setWorkInfo(new WorkInfo());
        work.getWorkInfo().setReflectedTimestamp(new Date());
        work.getWorkInfo().setScheduledDate(new Date());
        return work;
    }

}
