package jp.sourceforge.masme.validation.impl;

import java.lang.reflect.Method;

import jp.sourceforge.masme.meta.ReferenceMetaProperty;
import jp.sourceforge.masme.util.impl.MasmenEntityUtils;
import jp.sourceforge.masme.validation.ValidateFunction;
import jp.sourceforge.masme.validation.ValidateFunctionFactory;

/**
 * 
 * メソッドの実行を行う{@code ValidateFunction}の実装クラス
 */
public class MethodValidateFunctionFactory implements ValidateFunctionFactory {

    /**
     * @see jp.sourceforge.masme.validation.ValidateFunctionFactory#createValidateFunction(jp.sourceforge.masme.meta.ReferenceMetaProperty)
     */
    public ValidateFunction createValidateFunction(
            ReferenceMetaProperty referenceMetaProperty) {
        MethodValidateFunction validateFunction = new MethodValidateFunction();
        Method method = MasmenEntityUtils.findValidationMethod(
                referenceMetaProperty.getMetaClass().getRealClass(),
                referenceMetaProperty.getValidationMethodName(),
                referenceMetaProperty.getReferenceMetaClass().getRealClass());
        
        validateFunction.setMethod(method);

        return validateFunction;
    }
}
