package jp.sourceforge.masme.validation.impl;

import java.lang.reflect.Method;

import jp.sourceforge.masme.entity.MaintenanceEntity;
import jp.sourceforge.masme.util.impl.MasmenEntityUtils;
import jp.sourceforge.masme.validation.ValidateFunction;

/**
 * 
 * メソッドの実行を行う{@code ValidateFunction}の実装クラス
 */
public class MethodValidateFunction implements ValidateFunction {

    /**
     * 実行メソッド
     */
    private Method method;

    /**
     * @param method method を設定。
     */
    void setMethod(Method method) {
        this.method = method;
    }

    /**
     * @see jp.sourceforge.masme.validation.ValidateFunction#invoke(jp.sourceforge.masme.entity.MaintenanceEntity, jp.sourceforge.masme.entity.MaintenanceEntity)
     */
    public void invoke(MaintenanceEntity target, MaintenanceEntity other) {

        MasmenEntityUtils.invokeValidationMethod(method, target, other);

    }
}
