package jp.sourceforge.masme.validation;

import java.util.ArrayList;
import java.util.List;

/**
 * 失敗したことを示すバリデーションの実行結果を保持したオブジェクト
 */
public class MultipleValidationResult implements ValidationResult {
    List<ValidationResult> results = new ArrayList<ValidationResult>();

    public boolean validationSuccess() {
        for (ValidationResult result : results) {
            if (!result.validationSuccess()) {
                return false;
            }
        }
        return true;
    }

    public String getErrorMessage() {
        StringBuffer sb = new StringBuffer();
        for (ValidationResult result : results) {
            if (!result.validationSuccess()) {
                sb.append(result.getErrorMessage() + ",");
            }
        }
        return "error[" + sb.toString() + "]";
    }

    /**
     * @return results を戻します。
     */
    public List<ValidationResult> getResults() {
        return results;
    }

    public boolean validateNotWaitReflect() {
        for (ValidationResult result : results) {
            if (!result.validateNotWaitReflect()) {
                return false;
            }
        }
        return true;
    }

    public boolean validateReflectFirst() {
        for (ValidationResult result : results) {
            if (!result.validateReflectFirst()) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        String messsage;
        if (validationSuccess()) {
            messsage = "validationSuccess";
        } else {
            StringBuffer sb = new StringBuffer();
            for (ValidationResult result : results) {
                if (!result.validationSuccess()) {
                    sb.append(result.toString() + ",");
                }
            }
            messsage = sb.toString();
        }
        return getClass().getSimpleName() + ":" + messsage;
    }

}
