package jp.sourceforge.masme.target.impl;

import jp.sourceforge.masme.meta.MetaProperty;
import jp.sourceforge.masme.target.MaintenanceProperty;
import jp.sourceforge.masme.target.MaintenanceTarget;
import jp.sourceforge.masme.util.impl.MasmenEntityUtils;

/**
 * メンテナンス対象プロパティ
 */
public class MaintenancePropertyImpl extends MaintenanceSupport implements
        MaintenanceProperty {

    /**
     * メンテナンス対象オブジェクト
     */
    protected MaintenanceTarget maintenanceTarget;

    /**
     * プロパティのメタ情報
     */
    protected MetaProperty metaProperty;

    public MetaProperty getMetaProperty() {
        return metaProperty;
    }

    public MaintenancePropertyImpl(MaintenanceTarget target,
            MetaProperty metaProperty) {
        this.maintenanceTarget = target;
        this.metaProperty = metaProperty;
    }

    public String getPropertyName() {
        return metaProperty.getPropertyName();
    }

    public Object getPropertyValue() {
        return MasmenEntityUtils.getProperty(maintenanceTarget.getEntity(),
                getPropertyName());
    }

    public void setPropertyValue(Object value) {
        MasmenEntityUtils.setProperty(maintenanceTarget.getEntity(),
                getPropertyName(), value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(":");
        sb.append(metaProperty.getPropertyName());

        return sb.toString();
    }

}
