package jp.sourceforge.masme.target.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masme.entity.MaintenanceEntity;
import jp.sourceforge.masme.meta.MetaClass;
import jp.sourceforge.masme.meta.MetaProperty;
import jp.sourceforge.masme.meta.ReferenceMetaProperty;
import jp.sourceforge.masme.target.MaintenanceProperty;
import jp.sourceforge.masme.target.MaintenanceTarget;
import jp.sourceforge.masme.target.ValidateProperty;
import jp.sourceforge.masme.target.injection.MasmenInjectionUtils;
import jp.sourceforge.masme.util.impl.MasmenEntityUtils;

/**
 * メンテナンス対象オブジェクト
 * <p>
 * マスタメンテナンスシステムはこのオブジェクトを使って操作されます.
 */
public class AbstractMaintenanceTarget extends MaintenanceSupport implements
        MaintenanceTarget {
    /**
     * メンテナンス対象オブジェクトのメタ情報
     */
    private MetaClass maintenanceMetaClass;

    /**
     * メンテナンス対象プロパティ
     */
    private List<MaintenanceProperty> maintenanceProperties;

    private List<ValidateProperty> validateProperties;

    /**
     * メンテナンス対象のエンティティ
     */
    private MaintenanceEntity entity;
    private Class clazz;

    public AbstractMaintenanceTarget(Class clazz, MaintenanceEntity entity) {
        this.entity = entity;
        this.clazz = clazz;

    }

    public void init() {
        maintenanceMetaClass = metaInfo.findMetaClassByClass(clazz);
        if (maintenanceMetaClass == null) {
            throw new IllegalArgumentException("class["+clazz+"] is not maintenance target class");
        }
        // メンテナンスプロパティの設定
        maintenanceProperties = new ArrayList<MaintenanceProperty>();
        for (MetaProperty metaProperty : maintenanceMetaClass
                .getMetaProperties()) {
            MaintenanceProperty mp;
            if (metaProperty instanceof ReferenceMetaProperty) {
                mp = factory.createReferenceProperty(this, metaProperty);
            } else {
                mp = factory.createMaintenanceProperty(this, metaProperty);
            }
//            mp.setMetaProperty(metaProperty);
//            mp.setFromParent(this);
            MasmenInjectionUtils.setMaintenanceTargetDao(mp, dao);
            MasmenInjectionUtils.setMaintenanceTargetFactory(mp, factory);
            MasmenInjectionUtils.setMasmenMetaInfo(mp, metaInfo);
            MasmenInjectionUtils.setMasmenValidation(mp, validation);
            maintenanceProperties.add(mp);
        }
        // 整合性検証プロパティの設定
        validateProperties = new ArrayList<ValidateProperty>();
        for (ReferenceMetaProperty rMetaProperty : maintenanceMetaClass
                .getReferenceMetaProperties()) {
            ValidateProperty validateProperty = factory.createValidateProperty(this, rMetaProperty);
            MasmenInjectionUtils.setMaintenanceTargetDao(validateProperty, dao);
            MasmenInjectionUtils.setMaintenanceTargetFactory(validateProperty, factory);
            MasmenInjectionUtils.setMasmenMetaInfo(validateProperty, metaInfo);
            MasmenInjectionUtils.setMasmenValidation(validateProperty, validation);
//            validateProperty.setFromParent(this);
//            validateProperty.setRMetaProperty(rMetaProperty);
//            validateProperty.setMaintenanceTarget(this);
            validateProperties.add(validateProperty);
        }

    }

    public Serializable getId() {
        return (Serializable) MasmenEntityUtils.getProperty(entity,
                maintenanceMetaClass.getIdName());
    }

    public MetaClass getMaintenanceMetaClass() {
        return maintenanceMetaClass;
    }

    public List<MaintenanceProperty> getMaintenanceProperties() {
        return maintenanceProperties;
    }

    public void setId(Serializable id) {
        MasmenEntityUtils.setProperty(entity, maintenanceMetaClass.getIdName(),
                id);
    }

    public MaintenanceEntity getEntity() {
        return entity;
    }

    public List<ValidateProperty> getValidateProperties() {
        return validateProperties;
    }

    public MaintenanceProperty getMaintenanceProperty(String propertyName) {
        for (MaintenanceProperty mp : getMaintenanceProperties()) {
            if (mp.getPropertyName().equals(propertyName)) {
                return mp;
            }
        }
        return null;
    }

}
