package jp.sourceforge.masme.target;

import jp.sourceforge.masme.validation.ValidationResult;

/**
 * Entityのプロパティのうち、別のメンテナンス対象Entityに対するプロパティ（参照プロパティ）です。
 * <p>
 * このオブジェクトでは、参照プロパティとこのプロパティを保持するエンティティとの
 * バリデーションが正しいかどうかを検証するために利用します。
 */
public interface ReferenceProperty extends MaintenanceProperty {

    /**
     * このプロパティに対応するワークエンティティを返します。
     * @return
     */
    MaintenanceWorkTarget getReferenceWorkTarget();

    /**
     * このプロパティに対応するワークエンティティを返します。
     * @return
     */
    MaintenanceRealTarget getReferenceRealTarget();

    /**
     * バリデーションメソッドを、
     * ワークの参照プロパティとこのプロパティを保持するエンティティとで実行します
     * 
     */
    ValidationResult invokeWorkValidateMethod();

    /**
     * バリデーションメソッドを、
     * 本番の参照プロパティとこのプロパティを保持するエンティティとで実行します
     * 
     */
    ValidationResult invokeRealValidateMethod();

}