package jp.sourceforge.masme.target;

import java.io.Serializable;
import java.util.List;

import jp.sourceforge.masme.entity.MaintenanceEntity;

/**
 * Entityのラッパークラス
 * <p>
 * マスタメンテナンスシステムはこのオブジェクトを使って操作されます.
 */
public interface MaintenanceTarget {
    /**
     * IDを取得します
     */
    Serializable getId();

    /**
     * IDを設定します.
     */
    void setId(Serializable id);

    /**
     * メンテナンス対象のプロパティを取得します.
     * 
     * @return
     */
    List<MaintenanceProperty> getMaintenanceProperties();

    /**
     * プロパティ名を元に、メンテナンス対象プロパティを取得します
     * @return
     */
    MaintenanceProperty getMaintenanceProperty(String propertyName);

    /**
     * メンテナンス対象エンティティを取得します
     */
    MaintenanceEntity getEntity();

    /**
     * 整合性を保つ対象となるプロパティを取得します
     * @return
     */
    List<ValidateProperty> getValidateProperties();

}
