package jp.sourceforge.masme.service.impl;

import java.util.Date;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.service.ConfirmEntityService;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

public class ConfirmEntityServiceImpl<E extends WorkEntity>
        extends AbstractEntityService<E> implements ConfirmEntityService<E> {
    
    /**
     * @see jp.sourceforge.masme.service.ConfirmEntityService#confirm(jp.sourceforge.masme.entity.WorkEntity)
     */
    public void confirm(E entity) {
        MaintenanceWorkTarget workTarget = getMaintenanceWorkTarget(entity);
        workTarget.confirm();
    }

    /**
     * @see jp.sourceforge.masme.service.ConfirmEntityService#cancelConfirm(jp.sourceforge.masme.entity.WorkEntity)
     */
    public void cancelConfirm(E entity) {
        MaintenanceWorkTarget workTarget = getMaintenanceWorkTarget(entity);
        workTarget.cancelConfirm();
        
    }

    /**
     * @see jp.sourceforge.masme.service.ConfirmEntityService#changeReflectDate(jp.sourceforge.masme.entity.WorkEntity, java.util.Date)
     */
    public void changeReflectDate(E entity, Date reflectDate) {
        MaintenanceWorkTarget workTarget = getMaintenanceWorkTarget(entity);
        workTarget.changeScheduleDate(reflectDate);
        
    }

}
