package jp.sourceforge.masme.meta;

import jp.sourceforge.masme.validation.ValidateFunction;

/**
 * 参照形式のプロパティのメタ情報
 */
public class ReferenceMetaProperty extends MetaProperty {
    /**
     * プロパティに対応するワークのプロパティ名
     */
    private String workPropertyName;

    /**
     * プロパティが参照するクラスの参照しているプロパティ名
     */
    private String referencedPropertyName;

    /**
     * プロパティが参照するクラスの参照しているワークのプロパティ名
     */
    private String workReferencedPropertyName;

    /**
     * 参照が正しいかの検証を行うメソッド名
     */
    private String validationMethodName;
    /**
     * プロパティが参照するクラスのメタ情報
     */
    private MetaClass referenceMetaClass;
    
    /**
     * 検証を行う処理
     */
    private ValidateFunction validateFunction;

    protected ReferenceMetaProperty(String propertyName,
            String workPropertyName, String referencedPropertyName,
            String workReferencedPropertyName, String validationMethodName,
            Class propertyType, MetaClass metaClass) {
        super(propertyName, propertyType, metaClass);
        this.workPropertyName = workPropertyName;
        this.referencedPropertyName = referencedPropertyName;
        this.workReferencedPropertyName = workReferencedPropertyName;
        this.validationMethodName = validationMethodName;
    }

    public String getWorkPropertyName() {
        return workPropertyName;
    }

    public String getReferencedPropertyName() {
        return referencedPropertyName;
    }

    public String getWorkReferencedPropertyName() {
        return workReferencedPropertyName;
    }

    public MetaClass getReferenceMetaClass() {
        return referenceMetaClass;
    }

    void setReferenceMetaClass(MetaClass metaClass) {
        this.referenceMetaClass = metaClass;
        referenceMetaClass.addReferenceMetaProperty(this);
    }

    void setValidateFunction(ValidateFunction validateFunction) {
        this.validateFunction = validateFunction;
    }

    public String getValidationMethodName() {
        return validationMethodName;
    }

    /**
     * @return validateFunction を戻します。
     */
    public ValidateFunction getValidateFunction() {
        return validateFunction;
    }

}
