package jp.sourceforge.masme.meta;

/**
 * メンテナンス対象のプロパティのメタ情報を保持したクラス
 *
 */
public class MetaProperty {
    /**
     * メンテナンス対象のプロパティ名
     */
    private String propertyName;
    /**
     * メンテナンス対象のプロパティのクラス
     */
    private Class propertyType;
    /**
     * メンテナンス対象のクラス
     */
    private MetaClass metaClass;

    protected MetaProperty(String propertyName, Class propertyType,
            MetaClass metaClass) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.metaClass = metaClass;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public Class getPropertyType() {
        return propertyType;
    }

    public MetaClass getMetaClass() {
        return metaClass;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((metaClass == null) ? 0 : metaClass.hashCode());
        result = prime * result
                + ((propertyName == null) ? 0 : propertyName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final MetaProperty other = (MetaProperty) obj;
        if (metaClass == null) {
            if (other.metaClass != null)
                return false;
        } else if (!metaClass.equals(other.metaClass))
            return false;
        if (propertyName == null) {
            if (other.propertyName != null)
                return false;
        } else if (!propertyName.equals(other.propertyName))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return propertyName + ":" + propertyType.getSimpleName() + "("
                + metaClass + ")";
    }

}