package jp.sourceforge.masme.meta;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.ListUtils;

/**
 * マスタメンテナンスのメタ情報格納クラス
 */
public class MasmenMetaInfo {
    private List<MetaClass> metaClasses;

    protected MasmenMetaInfo() {
        this.metaClasses = new ArrayList<MetaClass>();
    }

    @SuppressWarnings("unchecked")
    public List<MetaClass> getMetaClasses() {
        return ListUtils.unmodifiableList(metaClasses);
    }

    public MetaClass findMetaClassByClass(Class clazz) {
        for (MetaClass metaClass : metaClasses) {
            if (metaClass.getRealClass().equals(clazz)) {
                return metaClass;
            }
            if (metaClass.getWorkClass().equals(clazz)) {
                return metaClass;
            }
        }
        return null;
    }

    void addMetaClass(MetaClass metaClass) {
        if (metaClasses.contains(metaClass)) {
            throw new IllegalArgumentException("2重登録" + metaClass);
        }
        metaClasses.add(metaClass);
    }
}
