package jp.sourceforge.masme.meta;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Id;

import jp.sourceforge.masme.annotation.MaintenanceTargetProperty;
import jp.sourceforge.masme.annotation.ReferenceTargetProperty;

import org.springframework.beans.BeanUtils;

public class MasmenAnnotationUtils {

    /**
     * アノテーション情報をもとにIDプロパティ名を取得します
     * 
     * @param clazz
     * @return
     */
    public static String getIdPropertyName(Class clazz) {
        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(clazz);

        for (PropertyDescriptor pd : pds) {
            boolean maintenaceTarget = pd.getReadMethod().isAnnotationPresent(
                    Id.class);
            if (maintenaceTarget) {
                return pd.getDisplayName();
            }
        }
        return null;
    }

    /**
     * アノテーション情報をもとにメンテナンス対象プロパティを取得します
     * 
     * @param metaClass
     * @return
     */
    public static List<MetaProperty> getMaintenanceProperties(
            MetaClass metaClass) {

        PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(metaClass
                .getRealClass());
        List<MetaProperty> metaProperties = new ArrayList<MetaProperty>();

        for (PropertyDescriptor pd : pds) {
            boolean maintenaceTarget = pd.getReadMethod().isAnnotationPresent(
                    MaintenanceTargetProperty.class);
            if (maintenaceTarget) {
                // プロパティ名・プロパティのクラス
                String propertyName = pd.getDisplayName();
                Class propertyType = pd.getPropertyType();

                MetaProperty metaProperty;
                MaintenanceTargetProperty propertyAnnotation = pd
                        .getReadMethod().getAnnotation(
                                MaintenanceTargetProperty.class);
                ReferenceTargetProperty[] refTarget = propertyAnnotation
                        .referenceTarget();
                // もし参照を行うプロパティであれば
                if (refTarget.length != 0) {
                    String workPropertyName = refTarget[0].workPropertyName();
                    String referencePropertyName = refTarget[0]
                            .referencePropertyName();
                    String workReferencePropertyName = refTarget[0]
                            .workReferencePropertyName();
                    String validationMethodName = refTarget[0]
                            .validationMethodName();
                    metaProperty = new ReferenceMetaProperty(propertyName,
                            workPropertyName, referencePropertyName,
                            workReferencePropertyName, validationMethodName,
                            propertyType, metaClass);
                } else {
                    metaProperty = new MetaProperty(pd.getDisplayName(), pd
                            .getPropertyType(), metaClass);
                }
                metaProperties.add(metaProperty);
            }
        }
        return metaProperties;
    }
}
