package jp.sourceforge.masme.dao.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import jp.sourceforge.masme.dao.MaintenanceTargetDao;
import jp.sourceforge.masme.entity.ReflectState;
import jp.sourceforge.masme.entity.WorkEntity;

import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;


public class MaintenanceTargetDaoImpl extends HibernateDaoSupport implements
        MaintenanceTargetDao {

    public void delete(Object obj) {
        getHibernateTemplate().delete(obj);
    }

    public WorkEntity get(Class targetClass, Serializable key) {
        return (WorkEntity) getHibernateTemplate().get(targetClass, key);
    }

    public List loadAll(Class targetClass) {
        return getHibernateTemplate().loadAll(targetClass);
    }

    public Serializable save(Object obj) {
        return getHibernateTemplate().save(obj);
    }

    public void update(Object obj) {
        getHibernateTemplate().update(obj);
    }

    public List loadEditAll(Class targetClass) {
        Criteria crt = getSession().createCriteria(targetClass);

        crt.add(Restrictions.in("workInfo.reflectState", new Object[] {
                ReflectState.EDITED, ReflectState.WAIT_REFLECT }));
        return crt.list();
    }

    public List loadWaitReflectAll(Class targetClass, Date reflectDate) {
        Criteria crt = getSession().createCriteria(targetClass);

        crt.add(Restrictions.eq("workInfo.reflectState",
                ReflectState.WAIT_REFLECT));
        if (reflectDate != null) {
            crt.add(Restrictions.eq("workInfo.scheduledDate", reflectDate));
        }
        ;
        return crt.list();
    }
}
