package jp.sourceforge.masme;

import java.util.ArrayList;
import java.util.List;

public class MasmenValidateException extends RuntimeException {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private List<String> errMsgs = new ArrayList<String>();

    public MasmenValidateException() {
    }

    public MasmenValidateException(String errMsg) {
        super(errMsg);
        errMsgs.add(errMsg);
    }

    public MasmenValidateException(List<String> errMsgs) {
        super(errMsgs.toString());
        errMsgs.addAll(errMsgs);
    }

    public List<String> getErrMsgs() {
        return errMsgs;
    }

}
