/*
 * Copyright (c)  2006-2010 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @class 指定したレイアウトを解放するクラスです。
 *
 * @name maskat.control.UnloadLayoutCommand
 * @extends maskat.control.Command
 */ 
maskat.lang.Class.declare("maskat.control.UnloadLayoutCommand")
	.extend("maskat.control.Command", {
	
	/** @scope maskat.control.UnloadLayoutCommand.prototype */
	
	/**
	 * コンストラクタです。 
	 */
	initialize: function(layoutId) {
		this.layoutId = layoutId;
	},

	execute: function(app) {
		app.unloadLayout(this.layoutId);
	}

});
