/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.Text;
import org.maskat.ui.views.properties.descriptor.BooleanComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.ComboBoxLabelConstants;
import org.maskat.ui.views.properties.descriptor.MaskatComboBoxPropertyDescriptor;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class TextPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_NAME = "_prop_name_";
	
	public static final String PROP_LEFT = "_prop_left_";
	
	public static final String PROP_TOP = "_prop_top_";
	
	public static final String PROP_WIDTH = "_prop_width_";
	
	public static final String PROP_ACCESSKEY = "_prop_accessKey_";
	
	public static final String PROP_AUTOUP = "_prop_autoUp_";
	
	public static final String PROP_DATATYPE = "_prop_datatype_";
	
	public static final String PROP_DISABLE = "_prop_disable_";
	
	public static final String PROP_INITVALUE = "_prop_initValue_";
	
	public static final String PROP_ISREQUIRED = "_prop_isRequired_";
	
	public static final String PROP_POSITION = "_prop_position_";
	
	public static final String PROP_ROWS = "_prop_rows_";
	
	public static final String PROP_NBCHAR = "_prop_nbchar_";
	
	public static final String PROP_TABINDEX = "_prop_tabIndex_";

	public TextPropertySource(Text text) {
		super(text);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_NAME, "name"),
				  new MaskatTextPropertyDescriptor(PROP_LEFT, "left"),
				  new MaskatTextPropertyDescriptor(PROP_TOP, "top"),
				  new MaskatTextPropertyDescriptor(PROP_WIDTH, "width"),
				  new MaskatTextPropertyDescriptor(PROP_TABINDEX, "tabIndex"),
				  new MaskatComboBoxPropertyDescriptor(PROP_DATATYPE, "datatype", ComboBoxLabelConstants.TEXT_DATATYPE),
				  new MaskatTextPropertyDescriptor(PROP_INITVALUE, "initValue"),
				  new BooleanComboBoxPropertyDescriptor(PROP_ISREQUIRED, "isRequired"),
				  new BooleanComboBoxPropertyDescriptor(PROP_DISABLE, "disable"),
				  new MaskatComboBoxPropertyDescriptor(PROP_POSITION, "position", ComboBoxLabelConstants.POSITION),
				  //new MaskatTextPropertyDescriptor(PROP_ACCESSKEY, "accessKey"),
				  new BooleanComboBoxPropertyDescriptor(PROP_AUTOUP, "autoUp"),
				  new MaskatTextPropertyDescriptor(PROP_ROWS, "rows"),
				  new MaskatTextPropertyDescriptor(PROP_NBCHAR, "nbchar")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_NAME, "name");
	    propMap.put(PROP_LEFT, "left");
	    propMap.put(PROP_TOP, "top");
	    propMap.put(PROP_WIDTH, "width");
	    //propMap.put(PROP_ACCESSKEY, "accessKey");
	    propMap.put(PROP_AUTOUP, "autoUp");
	    propMap.put(PROP_DATATYPE, "datatype");
	    propMap.put(PROP_DISABLE, "disable");
	    propMap.put(PROP_INITVALUE, "initValue");
	    propMap.put(PROP_ISREQUIRED, "isRequired");
	    propMap.put(PROP_POSITION, "position");
	    propMap.put(PROP_ROWS, "rows");
	    propMap.put(PROP_NBCHAR, "nbchar");
	    propMap.put(PROP_TABINDEX, "tabIndex");

	}
}
