/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.views.properties;

import org.eclipse.ui.views.properties.PropertyDescriptor;

import org.maskat.core.layout.ComboItem;
import org.maskat.ui.views.properties.descriptor.MaskatTextPropertyDescriptor;

public class ComboItemPropertySource extends AbstractComponentPropertySource {

	public static final String PROP_TEXT = "_prop_text_";

	public static final String PROP_VALUE = "_prop_value_";

	public ComboItemPropertySource(ComboItem comboItem) {
		super(comboItem);
	}
	
	protected void initialize() {
		descriptor = new PropertyDescriptor[] {
				  new MaskatTextPropertyDescriptor(PROP_TEXT, "text"),
				  new MaskatTextPropertyDescriptor(PROP_VALUE, "value")};
		
		//make sure the "..." values are the same as bean's properties.
	    propMap.put(PROP_TEXT, "text");
	    propMap.put(PROP_VALUE, "value");

	}
}
