/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;

public class ContainerFigure extends Label {
	private Rectangle PRIVATE_POINT = new Rectangle();
	
	public ContainerFigure() {
		setForegroundColor(ColorConstants.black);
		setLayoutManager(new XYLayout());
	}
	
	protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
		PRIVATE_POINT.setLocation(x, y);
		translateFromParent(PRIVATE_POINT);
		if (getClientArea(Rectangle.SINGLETON).contains(PRIVATE_POINT))
			return null;

		x = PRIVATE_POINT.x;
		y = PRIVATE_POINT.y;
		IFigure fig;
		IFigure result = null;
		for (int i = getChildren().size(); i > 0;) {
			i--;
			fig = (IFigure) getChildren().get(i);
			if (fig.isVisible()) {
				if (fig instanceof ComboItemFigure) {
					return fig;
					// マウス動作を優先にcomboItemに取らせるために。
				} else {
					if (result == null)
						result = fig;
				}
			}
		}
		// Returns descendant that was found
		return result;
	}

	protected void paintChildren(Graphics graphics) {
		super.paintChildren(graphics);
	}
}
