/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.ui.editors.layout.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;

import org.maskat.core.layout.Component;
import org.maskat.core.layout.TabFolder;
import org.maskat.core.layout.TabItem;
import org.maskat.ui.editors.layout.figures.TabFolderFigure;
import org.maskat.ui.editors.layout.models.TabDef;

public class TabFolderEditPart extends ComponentEditPart
	implements HorizontalResizable, VerticalResizable {

	TabFolderFigure tabFolderFigure;

	protected void switchToPage(String pageName) {
		tabFolderFigure.setAllTabPageInvisible();

		// 選択中のタブページだけ表示
		tabFolderFigure.showNamedTabPage(pageName);
	}

//	protected List getModelChildren() {
//		TabFolder tabFolder = (TabFolder) getModel();
//		List children = tabFolder.getComponents();
//		List result = new ArrayList();
//		for (Iterator it = children.iterator(); it.hasNext();) {
//			TabItem tabItem = (TabItem) it.next();
//			TabDef tabDef = new TabDef(tabFolder, tabItem);
//			result.add(tabItem);
//			result.add(tabDef);
//		}
//		return result;
//	}

	protected List getModelChildren() {
		TabFolder tabFolder = (TabFolder) getModel();
		List result = new ArrayList();
		for (Iterator it = tabFolder.getChildren(); it != null && it.hasNext();) {
			TabItem tabItem = (TabItem) it.next();
//			TabDef tabDef = new TabDef(tabFolder, tabItem);
			TabDef tabDef = new TabDef(tabItem);
			result.add(tabItem);
			result.add(tabDef);
		}
		return result;
	}
	
	protected IFigure createFigure() {
		tabFolderFigure = new TabFolderFigure();
		return tabFolderFigure;
	}

	protected void refreshVisuals() {
		// 制約の取得
		Component comp = (Component) getModel();
		Rectangle constraint = new Rectangle(comp.getLeft(), comp.getTop(), 
				comp.getWidth(), comp.getHeight());

		((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(),
				constraint);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName())
				|| "removeChild".equals(evt.getPropertyName())) {
			refreshChildren();
		} else 	if ("widthTabName".equals(evt.getPropertyName())) {
			// タブタイトルの幅が変更されたら、画面上のタブを再描画
			for (Iterator it = this.getChildren().iterator(); it != null && it.hasNext();) {
				Object child = it.next();
				if (child instanceof TabEditPart) {
					((TabEditPart) child).selfLayout((String) evt.getNewValue());
				}
			}
		} else if ("constraint".equals(evt.getPropertyName())) {
			Rectangle rect = getFigure().getBounds();
			for (Iterator it = this.getChildren().iterator(); it != null && it.hasNext();) {
				Object child = it.next();
				if (child instanceof TabItemEditPart) {
					TabItemEditPart editPart = (TabItemEditPart) child;
					TabItem item = (TabItem) editPart.getModel();
					item.setHeight(rect.height);
					item.setLeft(rect.width);
				}
			}			
		}
//		refreshVisuals();
		super.propertyChange(evt);
	}
}
