/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout.custom;

import java.util.ArrayList;
import java.util.List;

import org.maskat.core.MaskatElement;

import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaProperty;

public class UnknownComponentClass extends BasicDynaClass {
	
	private static final long serialVersionUID = 6649622981353389752L;

	public UnknownComponentClass() {
		super();
	}
	
	public UnknownComponentClass(String name, Class dynaBeanClass, DynaProperty[] properties) {
		super(name, dynaBeanClass, properties);
	}
	
	public UnknownComponentClass(String name, Class dynaBeanClass, String[] properties) {
		super(name, dynaBeanClass, null);
		setProperties(properties);
	}
	
	private void setProperties(String[] properties) {
		List list = new ArrayList();
		list.add(new DynaProperty("parent", MaskatElement.class));
		list.add(new DynaProperty("children", List.class));

		for (int i=0; properties != null && i < properties.length; i++) {
			list.add(new DynaProperty(properties[i], String.class));
		}
		setProperties((DynaProperty[]) list.toArray(new DynaProperty[list.size()]));
	}
	
	public void setDynaProperties(DynaProperty[] properties) {
        setProperties(properties);
    }
	
	public void setDynaBeanClass(Class dynaBeanClass) {
        super.setDynaBeanClass(dynaBeanClass);
    }
	
}
