/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class TreeNodeBeanInfo extends SimpleBeanInfo {

	public PropertyDescriptor[] getPropertyDescriptors() {
		PropertyDescriptor[] descs = null;
		PropertyDescriptor[] TreeNodeDefPropDesc = null;
		// GrameDefの親クラスのBeanInfo
		try {
			BeanInfo info = Introspector.getBeanInfo(AbstractComponent.class);
			descs = info.getPropertyDescriptors();
			TreeNodeDefPropDesc = new PropertyDescriptor[] {
					new PropertyDescriptor("name", TreeNode.class),
					new PropertyDescriptor("sText", TreeNode.class),
					new PropertyDescriptor("sIcon", TreeNode.class),
					new PropertyDescriptor("sIcon2", TreeNode.class),
					new PropertyDescriptor("open", TreeNode.class),
//					new PropertyDescriptor("reload", TreeNode.class),
//					new PropertyDescriptor("url", TreeNode.class),
//					new PropertyDescriptor("typeInfo", TreeNode.class),
//					new PropertyDescriptor("position", TreeNode.class),
					new PropertyDescriptor("draggable", TreeNode.class),
					new PropertyDescriptor("onclick", TreeNode.class) };
		} catch (IntrospectionException e) {
			return null;
		}

		// TreeNodeDef自身のPropertyDescriptor[]を追加
		PropertyDescriptor[] result = new PropertyDescriptor[descs.length
				+ TreeNodeDefPropDesc.length];
		System.arraycopy(descs, 0, result, 0, descs.length);
		System.arraycopy(TreeNodeDefPropDesc, 0, result, descs.length,
				TreeNodeDefPropDesc.length);
		return result;
	}

}
