/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import org.maskat.core.event.EventTypeConstants;

public class Text extends AbstractComponent {
	
	public static final String ACCESS_KEY_DEFAULT = "";
	
	public static final boolean IS_REQUIRED_DEFAULT = false;
	
	public static final boolean DISABLE_DEFAULT = false;
	
	public static final boolean AUTO_UP_DEFAULT = false;
	
	public static final String DATA_TYPE_DEFAULT = "A";
	
	public static final String POSITION_DEFAULT = "relative";
	
	public static final int ROWS_DEFAULT = 5;
	
	public static final int NBCHAR_DEFAULT = 50;
	
	public static final int TABINDEX_DEFAULT = 0;


	private String datatype = DATA_TYPE_DEFAULT;

	private boolean isRequired = IS_REQUIRED_DEFAULT;

	private boolean disable = DISABLE_DEFAULT;

	private boolean autoUp = AUTO_UP_DEFAULT;

	private int rows = ROWS_DEFAULT;

	private String initValue;

	private String accessKey = ACCESS_KEY_DEFAULT;

	private int nbchar = NBCHAR_DEFAULT;

//	private String tabIndex;
	
	private String position = POSITION_DEFAULT;

	public Text() {
		setTabIndex(TABINDEX_DEFAULT);
	}
	
	public boolean isAutoUp() {
		return autoUp;
	}

	public void setAutoUp(boolean autoUp) {
		this.autoUp = autoUp;
	}

	public boolean isDisable() {
		return disable;
	}

	public void setDisable(boolean disable) {
		this.disable = disable;
	}

	public boolean isIsRequired() {
		return isRequired;
	}

	public void setIsRequired(boolean isRequired) {
		this.isRequired = isRequired;
	}

	public int getRows() {
		return rows;
	}

	public void setRows(int rows) {
		this.rows = rows;
	}

	public String getDatatype() {
		return datatype;
	}

	public void setDatatype(String type) {
		this.datatype = type;
	}

	public String getAccessKey() {
		return accessKey;
	}

	public void setAccessKey(String accessKey) {
		this.accessKey = accessKey;
	}

	public String getInitValue() {
		return initValue;
	}

	public void setInitValue(String initValue) {
		String oldInitValue = this.initValue;
		this.initValue = initValue;		
		firePropertyChange("text", oldInitValue, initValue);
	}

	public int getNbchar() {
		return nbchar;
	}

	public void setNbchar(int nbchar) {
		this.nbchar = nbchar;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

//	public String getTabIndex() {
//		return tabIndex;
//	}
//
//	public void setTabIndex(String tabIndex) {
//		this.tabIndex = tabIndex;
//	}

	public String[] getEventTypes() {
		return new String[] {
				EventTypeConstants.ON_BLUR,
				EventTypeConstants.ON_FOCUS};
	}
}
