/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class PopupBeanInfo extends SimpleBeanInfo {

	public PropertyDescriptor[] getPropertyDescriptors() {
		PropertyDescriptor[] descs = null;
		PropertyDescriptor[] PopupDefPropDesc = null;
		
		// PopupDefの親クラスのBeanInfo
		try {
			BeanInfo info = Introspector.getBeanInfo(AbstractComponent.class);
			descs = info.getPropertyDescriptors();
			PopupDefPropDesc = new PropertyDescriptor[] {
					new PropertyDescriptor("title", Popup.class),
					new PropertyDescriptor("content", Popup.class),
					new PropertyDescriptor("modeContainer", Popup.class),
					new PropertyDescriptor("bSansBtonClose", Popup.class),
					new PropertyDescriptor("suffFond", Popup.class),
					new PropertyDescriptor("draggable", Popup.class),
//					new PropertyDescriptor("enable", Popup.class),
					new PropertyDescriptor("position", Popup.class),
					new PropertyDescriptor("visible", Popup.class),
					new PropertyDescriptor("withCloseButon", Popup.class) };
		} catch (IntrospectionException e) {
			return null;
		}

		// PopupDef自身のPropertyDescriptor[]を追加
		PropertyDescriptor[] result = new PropertyDescriptor[descs.length
				+ PopupDefPropDesc.length];
		System.arraycopy(descs, 0, result, 0, descs.length);
		System.arraycopy(PopupDefPropDesc, 0, result, descs.length,
				PopupDefPropDesc.length);
		return result;
	}

}
