/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import org.maskat.core.MaskatElement;

public interface LayoutElement extends MaskatElement {

	/**
	 * The component tree is always within a outer-most container, which is
	 * called the layout definition. The layout definition is a
	 * <code>IComponentDef</code> of course. Calling getLayoutDef on layout
	 * definition will return itself.
	 * 
	 * @return layout which contains this element
	 */
	public Layout getLayout();

}
