/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.util.Map;

import org.maskat.core.event.EventDef;

/**
 * The instance of this class represents the outer-most node of the layout
 * definition xml (&lt;maskat&gt;)
 */
public class LayoutDef extends AbstractLayoutElement {

	private Map namespaces;

	private EventDef eventDef;

	public Map getNamespaces() {
		return namespaces;
	}

	public void setNamespaces(Map namespaces) {
		this.namespaces = namespaces;
	}

	public String getPrefix(String namespaceURI) {
		return (String) namespaces.get(namespaceURI);
	}
	
	public EventDef getEventDef() {
		return eventDef;
	}

	public void setEventDef(EventDef eventDef) {
		this.eventDef = eventDef;
	}

	public void addJavaScriptGlobal(String content) {
		JavaScriptGlobal javascriptDef = new JavaScriptGlobal();
		javascriptDef.setContent(content);
		addChild(javascriptDef);
	}

	public void addChild(Object child) {
		if (child instanceof Layout) {
			((Layout) child).setLayoutDef(this);
		}
		super.addChild(child);
	}

	public void addChildToIdx(Object child, int idx) {
		if (child instanceof Layout) {
			((Layout) child).setLayoutDef(this);
		}
		super.addChildToIdx(child, idx);
	}

}
