/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

public class GridHeader extends AbstractLayoutElement implements ComponentPart {
	
	public static final String TITLE_DEFAULT = "undefined";

	private int width;

	private String title = TITLE_DEFAULT;

	private String type;

	private Grid grid;

	public int idxInParent() {
		return (grid == null) ? -1 : grid.indexOfHeader(this);
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
		if (grid != null) {
			grid.firePropertyChange("gridHeaderTitle", null, "");
		}
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		int old = this.width;
		this.width = width;
		if (grid != null) {
			grid.firePropertyChange("gridHeaderWidth", String.valueOf(old), String.valueOf(width));
		}
	}

	public Grid getGrid() {
		return grid;
	}

	public void setGrid(Grid parent) {
		this.grid = parent;
	}

}
