/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;

public class GridBeanInfo extends SimpleBeanInfo {
	
	public PropertyDescriptor[] getPropertyDescriptors() {
		PropertyDescriptor[] descs = null;
		PropertyDescriptor[] gridDefPropDesc = null;
		// GrameDefの親クラスのBeanInfo
		try {
			BeanInfo info = Introspector.getBeanInfo(AbstractComponent.class);
			descs = info.getPropertyDescriptors();
			gridDefPropDesc = new PropertyDescriptor[] {
					new PropertyDescriptor("rang", Grid.class),
//					new PropertyDescriptor("autoResizeParent", Grid.class),
					new PropertyDescriptor("lineHeight", Grid.class),
					new PropertyDescriptor("multiSelect", Grid.class),
					new PropertyDescriptor("actifClic", Grid.class),
					new PropertyDescriptor("cellActive", Grid.class),
					new PropertyDescriptor("bNavig", Grid.class),
					new PropertyDescriptor("boolPrint", Grid.class),
					new PropertyDescriptor("sortable", Grid.class),
					new PropertyDescriptor("widthLastCell", Grid.class),
					new PropertyDescriptor("TabEntete", Grid.class),
//					new PropertyDescriptor("printTitle", Grid.class),
//					new PropertyDescriptor("autoResizeContenu", Grid.class),
					new PropertyDescriptor("tabTypeCol", Grid.class),
					new PropertyDescriptor("switchable", Grid.class),
					new PropertyDescriptor("writable", Grid.class),
					new PropertyDescriptor("sortCol", Grid.class),
					new PropertyDescriptor("sortType", Grid.class), 
					new PropertyDescriptor("draggable", Grid.class),
					new PropertyDescriptor("onCellEdit", Grid.class),
//					new PropertyDescriptor("autoResizableH", Grid.class),
//					new PropertyDescriptor("autoResizableW", Grid.class),
					new PropertyDescriptor("position", Grid.class) };
		} catch (IntrospectionException e) {
			return null;
		}

		// GridDef自身のPropertyDescriptor[]を追加
		PropertyDescriptor[] result = new PropertyDescriptor[descs.length
				+ gridDefPropDesc.length];
		System.arraycopy(descs, 0, result, 0, descs.length);
		System.arraycopy(gridDefPropDesc, 0, result, descs.length,
						gridDefPropDesc.length);
		return result;
	}

}
