/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.layout;

import java.util.Iterator;

import org.maskat.core.event.EventTypeConstants;

public class Grid extends AbstractStructuredComponent {
	
	public static final String POSITION_DEFAULT = "absolute";
	
	public static final int RANG_DEFAULT = 15;
	
	public static final int LINE_HEIGHT_DEFAULT = 12;
	
	public static final int WIDTH_LAST_CELL_DEFAULT = 20;
	
	public static final boolean SORTABLE_DEFAULT = true;
	
	public static final boolean SWITCHABLE_DEFAULT = true;
	
	public static final boolean ACT_IF_CLIC_DEFAULT = true;
	
	public static final boolean BOOL_PRINT_DEFAULT = true;
	
	public static final boolean BNAVIG_DEFAULT = false;
	
	public static final boolean CELL_ACTIVE_DEFAULT = false;
	
	public static final boolean DRAGGABLE_DEFAULT = false;
	
	public static final boolean WRITABLE_DEFAULT = false;
	
	public static final boolean MULTI_SELECT_DEFAULT = false;
	
	public static final int SORTCOL_DEFAULT = 0;
	
	public static final String SORTTYPE_DEFAULT = "asc";
	
	public static final String ONCELL_EDIT_DEFAULT = "";

	public static final int TABINDEX_DEFAULT = -1;
	
	private int rang = RANG_DEFAULT;

	private int lineHeight = LINE_HEIGHT_DEFAULT;

	private boolean multiSelect = MULTI_SELECT_DEFAULT;

	private boolean actifClic = ACT_IF_CLIC_DEFAULT;

	private boolean cellActive = CELL_ACTIVE_DEFAULT;

	private boolean bNavig = BNAVIG_DEFAULT;

	private boolean boolPrint = BOOL_PRINT_DEFAULT;

	private boolean sortable = SORTABLE_DEFAULT;

	private int widthLastCell = WIDTH_LAST_CELL_DEFAULT;

	private boolean switchable = SWITCHABLE_DEFAULT;

	private boolean writable = WRITABLE_DEFAULT;

	private String TabEntete;

	private String tabTypeCol;

	private int sortCol = SORTCOL_DEFAULT;

	private String sortType = SORTTYPE_DEFAULT;
	
	private boolean draggable = DRAGGABLE_DEFAULT;

	private String position = POSITION_DEFAULT;
	
	private String onCellEdit = ONCELL_EDIT_DEFAULT;

	public Grid() {
		setTabIndex(TABINDEX_DEFAULT);
	}
	
	public boolean isActifClic() {
		return actifClic;
	}

	public void setActifClic(boolean actifClic) {
		this.actifClic = actifClic;
	}

	public boolean isSortable() {
		return sortable;
	}

	public void setSortable(boolean sortable) {
		this.sortable = sortable;
	}

	public boolean isSwitchable() {
		return switchable;
	}

	public void setSwitchable(boolean switchable) {
		this.switchable = switchable;
	}

	public int getWidthLastCell() {
		return widthLastCell;
	}

	public void setWidthLastCell(int widthlastcell) {
		this.widthLastCell = widthlastcell;
	}

	public boolean isWritable() {
		return writable;
	}

	public void setWritable(boolean writable) {
		this.writable = writable;
	}

	public boolean isBNavig() {
		return bNavig;
	}

	public void setBNavig(boolean naving) {
		bNavig = naving;
	}

	public boolean isBoolPrint() {
		return boolPrint;
	}

	public void setBoolPrint(boolean boolPrint) {
		this.boolPrint = boolPrint;
	}

	public boolean isCellActive() {
		return cellActive;
	}

	public void setCellActive(boolean cellActive) {
		this.cellActive = cellActive;
	}

	public int getLineHeight() {
		return lineHeight;
	}

	public void setLineHeight(int lineHeight) {
		int old = this.lineHeight;
		this.lineHeight = lineHeight;
		firePropertyChange("lineHeight", String.valueOf(old),
				String.valueOf(lineHeight));
	}

	public boolean isMultiSelect() {
		return multiSelect;
	}

	public void setMultiSelect(boolean multiSelect) {
		this.multiSelect = multiSelect;
	}

	public int getRang() {
		return rang;
	}

	public void setRang(int rang) {
		this.rang = rang;
	}

	public String getTabEntete() {
		return TabEntete;
	}

	public void setTabEntete(String tabEntete) {
		TabEntete = tabEntete;
	}

	public String getTabTypeCol() {
		return tabTypeCol;
	}

	public void setTabTypeCol(String tabTypeCol) {
		this.tabTypeCol = tabTypeCol;
	}

	public int getSortCol() {
		return sortCol;
	}

	public void setSortCol(int sortCol) {
		this.sortCol = sortCol;
	}

	public String getSortType() {
		return sortType;
	}

	public void setSortType(String sortType) {
		this.sortType = sortType;
	}

	public String getOnCellEdit() {
		return this.onCellEdit;
	}
	
	public void setOnCellEdit(String v) {
		this.onCellEdit = v;
	}
	
	public Iterator getHeadersIt() {
		return this.getTypedChildren(GridHeader.class);
	}

	public void addChild(Object comp) {
		if (comp instanceof GridHeader) {
			((GridHeader) comp).setGrid(this);
		}
		super.addChild(comp);
	}

	public void addChildToIdx(Object comp, int idx) {
		if (comp instanceof GridHeader) {
			((GridHeader) comp).setGrid(this);
		}
		super.addChildToIdx(comp, idx);
	}

	public int indexOfHeader(GridHeader headerDef) {
		Iterator headersIt = this.getHeadersIt();
		if (headersIt == null) {
			return -1;
		}
		int result = 0;
		while (headersIt.hasNext()) {
			if (headersIt.next().equals(headerDef)) {
				return result;
			}
			result++;
		}
		return -1;
	}

	public int headerTotalWidth() {
		Iterator headersIt = this.getHeadersIt();
		if (headersIt == null) {
			return 0;
		}
		int result = 0;
		while (headersIt.hasNext()) {
			GridHeader header = (GridHeader) headersIt.next();
			result += header.getWidth();
		}
		return result;
	}

	public boolean isDraggable() {
		return draggable;
	}

	public void setDraggable(boolean draggable) {
		this.draggable = draggable;
	}

	public String getPosition() {
		return position;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public String[] getEventTypes() {
		return new String[] {
				EventTypeConstants.ON_CLICK,
				EventTypeConstants.ON_DBLE_CLICK};
				//EventTypeConstants.ON_CELL_EDIT,
				//EventTypeConstants.ON_CLOSE};
	}

	public boolean canAddPart(ComponentPart child) {
		return  child instanceof GridHeader ||
				 child instanceof GridLine;
	}
}
