/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.betwixt;

import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;

import org.maskat.core.layout.custom.DynaComponentClass;

public class MaskatXMLIntrospector extends XMLIntrospector {

    /**
     * Creates XMLBeanInfo by reading the DynaProperties of a DynaBean.
     * Customizing DynaBeans using betwixt is not supported.
     * 
     * @param dynaClass the DynaBean to introspect
     * 
     * @return XMLBeanInfo for the DynaClass
     */
    public XMLBeanInfo introspect(DynaClass dynaClass) {
    	XMLBeanInfo xmlInfo = super.introspect(dynaClass);
    	ElementDescriptor descriptor = xmlInfo.getElementDescriptor();
     	String qualifiedName = ((DynaComponentClass) dynaClass).getQualifiedName();
    	descriptor.setQualifiedName(qualifiedName);
    	return xmlInfo;
    }
}