/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.betwixt;

import java.util.HashMap;
import java.util.Map;

import org.maskat.core.MaskatElement;
import org.maskat.core.event.Component;
import org.maskat.core.layout.Button;
import org.maskat.core.layout.Checkbox;
import org.maskat.core.layout.CodeLib;
import org.maskat.core.layout.Combo;
import org.maskat.core.layout.Desc;
import org.maskat.core.layout.DivHtml;
import org.maskat.core.layout.DivSplit;
import org.maskat.core.layout.Frame;
import org.maskat.core.layout.Grid;
import org.maskat.core.layout.GridHeader;
import org.maskat.core.layout.Label;
import org.maskat.core.layout.Popup;
import org.maskat.core.layout.Radio;
import org.maskat.core.layout.Splitter;
import org.maskat.core.layout.TabFolder;
import org.maskat.core.layout.Text;
import org.maskat.core.layout.TreeNode;
import org.maskat.core.layout.TreeView;
import org.maskat.core.layout.Window;

import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.strategy.ValueSuppressionStrategy;

public class LayoutValueSuppressionStrategy extends ValueSuppressionStrategy {

	private static final String DOT = ".";
	
	private Map attributeDefaultValues = new HashMap();
	
	private MaskatElement currentElement = null;
	
	public LayoutValueSuppressionStrategy() {
		attributeDefaultValues.put(Button.class.getName() + DOT + "adaptToText", String.valueOf(Button.ADAPT_TO_TEXT_DEFAULT));
		attributeDefaultValues.put(Button.class.getName() + DOT + "enable", String.valueOf(Button.ENABLE_DEFAULT));
		
		attributeDefaultValues.put(Checkbox.class.getName() + DOT + "checked", String.valueOf(Checkbox.CHECKED_DEFAULT));
		attributeDefaultValues.put(Checkbox.class.getName() + DOT + "enable", String.valueOf(Checkbox.ENABLE_DEFAULT));
		
		attributeDefaultValues.put(CodeLib.class.getName() + DOT + "alwaysRefresh", String.valueOf(CodeLib.ALWAYS_REFRESH_DEFAULT));
		attributeDefaultValues.put(CodeLib.class.getName() + DOT + "boolWithLabel", String.valueOf(CodeLib.BOOL_WITH_LABEL_DEFAULT));
		attributeDefaultValues.put(CodeLib.class.getName() + DOT + "codeWidth", String.valueOf(CodeLib.CODE_WIDTH_DEFAULT));
		attributeDefaultValues.put(CodeLib.class.getName() + DOT + "enable", String.valueOf(CodeLib.ENABLE_DEFAULT));
		attributeDefaultValues.put(CodeLib.class.getName() + DOT + "submitOnload", String.valueOf(CodeLib.SUBMIT_ONLOAD_DEFAULT));
		
		attributeDefaultValues.put(Combo.class.getName() + DOT + "enable", String.valueOf(Combo.ENABLE_DEFAULT));
		attributeDefaultValues.put(Combo.class.getName() + DOT + "heightItem", String.valueOf(Combo.HEIGHT_ITEM_DEFAULT));
		attributeDefaultValues.put(Combo.class.getName() + DOT + "position", String.valueOf(Combo.POSITION_DEFAULT));
		attributeDefaultValues.put(Combo.class.getName() + DOT + "suggest", String.valueOf(Combo.SUGGEST_DEFAULT));
		
		attributeDefaultValues.put(DivHtml.class.getName() + DOT + "position", String.valueOf(DivHtml.POSITION_DEFAULT));

		attributeDefaultValues.put(DivSplit.class.getName() + DOT + "backgroundColor", String.valueOf(DivSplit.BACKGROUND_COLOR_DEFAULT));
		
		attributeDefaultValues.put(Frame.class.getName() + DOT + "autoResizeParent", String.valueOf(Frame.AUTO_RESIZE_PARENT_DEFAULT));
		attributeDefaultValues.put(Frame.class.getName() + DOT + "boolMaxi", String.valueOf(Frame.BOOL_MAXI_DEFAULT));
		attributeDefaultValues.put(Frame.class.getName() + DOT + "boolPrint", String.valueOf(Frame.BOOL_PRINT_DEFAULT));
		attributeDefaultValues.put(Frame.class.getName() + DOT + "draggable", String.valueOf(Frame.DRAGGABLE_DEFAULT));
		attributeDefaultValues.put(Frame.class.getName() + DOT + "dynamic", String.valueOf(Frame.DYNAMIC_DEFAULT));
		attributeDefaultValues.put(Frame.class.getName() + DOT + "open", String.valueOf(Frame.OPEN_DEFAULT));
		attributeDefaultValues.put(Frame.class.getName() + DOT + "position", String.valueOf(Frame.POSITION_DEFAULT));
		attributeDefaultValues.put(Frame.class.getName() + DOT + "printTitle", String.valueOf(Frame.PRINT_TITLE_DEFAULT));
		attributeDefaultValues.put(Frame.class.getName() + DOT + "title", String.valueOf(Frame.TITLE_DEFAULT));
		
		attributeDefaultValues.put(Grid.class.getName() + DOT + "actifClic", String.valueOf(Grid.ACT_IF_CLIC_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "bNavig", String.valueOf(Grid.BNAVIG_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "boolPrint", String.valueOf(Grid.BOOL_PRINT_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "sortCol", String.valueOf(Grid.SORTCOL_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "sortType", String.valueOf(Grid.SORTTYPE_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "cellActive", String.valueOf(Grid.CELL_ACTIVE_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "draggable", String.valueOf(Grid.DRAGGABLE_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "lineHeight", String.valueOf(Grid.LINE_HEIGHT_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "multiSelect", String.valueOf(Grid.MULTI_SELECT_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "rang", String.valueOf(Grid.RANG_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "sortable", String.valueOf(Grid.SORTABLE_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "switchable", String.valueOf(Grid.SWITCHABLE_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "widthLastCell", String.valueOf(Grid.WIDTH_LAST_CELL_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "writable", String.valueOf(Grid.WRITABLE_DEFAULT));
		attributeDefaultValues.put(Grid.class.getName() + DOT + "onCellEdit", String.valueOf(Grid.ONCELL_EDIT_DEFAULT));
		
		attributeDefaultValues.put(GridHeader.class.getName() + DOT + "title", String.valueOf(GridHeader.TITLE_DEFAULT));
		
		attributeDefaultValues.put(Label.class.getName() + DOT + "className", String.valueOf(Label.CLASS_NAME_DEFAULT));
		attributeDefaultValues.put(Label.class.getName() + DOT + "position", String.valueOf(Label.POSITION_DEFAULT));
		
		attributeDefaultValues.put(Popup.class.getName() + DOT + "content", String.valueOf(Popup.CONTENT_DEFAULT));
		attributeDefaultValues.put(Popup.class.getName() + DOT + "draggable", String.valueOf(Popup.DRAGGABLE_DEFAULT));
		attributeDefaultValues.put(Popup.class.getName() + DOT + "suffFond", String.valueOf(Popup.SUFFFOND_DEFAULT));
		attributeDefaultValues.put(Popup.class.getName() + DOT + "title", String.valueOf(Popup.TITLE_DEFAULT));
		attributeDefaultValues.put(Popup.class.getName() + DOT + "visible", String.valueOf(Popup.VISIBLE_DEFAULT));
		attributeDefaultValues.put(Popup.class.getName() + DOT + "withCloseButon", String.valueOf(Popup.WITH_CLOSE_BUTTON_DEFAULT));

		attributeDefaultValues.put(Radio.class.getName() + DOT + "checked", String.valueOf(Radio.CHECKED_DEFAULT));
		attributeDefaultValues.put(Radio.class.getName() + DOT + "className", String.valueOf(Radio.CLASS_NAME_DEFAULT));
		attributeDefaultValues.put(Radio.class.getName() + DOT + "enable", String.valueOf(Radio.ENABLE_DEFAULT));
		
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "autoResizableH", String.valueOf(Splitter.AUTO_RESIZABLE_H_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "autoResizableW", String.valueOf(Splitter.AUTO_RESIZABLE_W_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "autoResizeParent", String.valueOf(Splitter.AUTO_RESIZE_PARENT_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "limInf", String.valueOf(Splitter.LIMINF_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "limSup", String.valueOf(Splitter.LIMSUP_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "orientation", String.valueOf(Splitter.ORIENTATION_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "overflow", String.valueOf(Splitter.OVERFLOW_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "position", String.valueOf(Splitter.POSITION_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "prop", String.valueOf(Splitter.PROP_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "reverseClose", String.valueOf(Splitter.REVERSE_CLOSE_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "style", String.valueOf(Splitter.STYLE_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "tailleCurs", String.valueOf(Splitter.TAILLECURS_DEFAULT));
		attributeDefaultValues.put(Splitter.class.getName() + DOT + "withImg", String.valueOf(Splitter.WITH_IMG_DEFAULT));
	
		attributeDefaultValues.put(TabFolder.class.getName() + DOT + "autoResizableH", String.valueOf(TabFolder.AUTO_RESIZABLE_H_DEFAULT));
		attributeDefaultValues.put(TabFolder.class.getName() + DOT + "autoResizableW", String.valueOf(TabFolder.AUTO_RESIZABLE_W_DEFAULT));
		attributeDefaultValues.put(TabFolder.class.getName() + DOT + "autoRedimTab", String.valueOf(TabFolder.AUTO_REDIM_TAB_DEFAULT));
		attributeDefaultValues.put(TabFolder.class.getName() + DOT + "draggable", String.valueOf(TabFolder.DRAGGABLE_DEFAULT));
		attributeDefaultValues.put(TabFolder.class.getName() + DOT + "draggableItem", String.valueOf(TabFolder.DRAGGABLE_ITEM_DEFAULT));
		attributeDefaultValues.put(TabFolder.class.getName() + DOT + "isClosable", String.valueOf(TabFolder.IS_CLOSABLE_DEFAULT));
		attributeDefaultValues.put(TabFolder.class.getName() + DOT + "noActiveTab", String.valueOf(TabFolder.NO_ACTIVE_TAB_DEFAULT));
		attributeDefaultValues.put(TabFolder.class.getName() + DOT + "orientation", String.valueOf(TabFolder.ORIENTATION_DEFAULT));
		attributeDefaultValues.put(TabFolder.class.getName() + DOT + "widthTabName", String.valueOf(TabFolder.WIDTH_TAB_NAME_DEFAULT));
		
		attributeDefaultValues.put(Text.class.getName() + DOT + "autoUp", String.valueOf(Text.AUTO_UP_DEFAULT));
		attributeDefaultValues.put(Text.class.getName() + DOT + "datatype", String.valueOf(Text.DATA_TYPE_DEFAULT));
		attributeDefaultValues.put(Text.class.getName() + DOT + "disable", String.valueOf(Text.DISABLE_DEFAULT));
		attributeDefaultValues.put(Text.class.getName() + DOT + "isRequired", String.valueOf(Text.IS_REQUIRED_DEFAULT));
		attributeDefaultValues.put(Text.class.getName() + DOT + "position", String.valueOf(Text.POSITION_DEFAULT));
		attributeDefaultValues.put(Text.class.getName() + DOT + "rows", String.valueOf(Text.ROWS_DEFAULT));
		attributeDefaultValues.put(Text.class.getName() + DOT + "nbchar", String.valueOf(Text.NBCHAR_DEFAULT));
		
		attributeDefaultValues.put(TreeNode.class.getName() + DOT + "open", String.valueOf(TreeNode.OPEN_DEFAULT));
		attributeDefaultValues.put(TreeNode.class.getName() + DOT + "sIcon", String.valueOf(TreeNode.SICON_DEFAULT));
		attributeDefaultValues.put(TreeNode.class.getName() + DOT + "sIcon2", String.valueOf(TreeNode.SICON2_DEFAULT));
		attributeDefaultValues.put(TreeNode.class.getName() + DOT + "sText", String.valueOf(TreeNode.STEXT_DEFAULT));

		attributeDefaultValues.put(TreeView.class.getName() + DOT + "autoResizableH", String.valueOf(TreeView.AUTO_RESIZABLE_H_DEFAULT));
		attributeDefaultValues.put(TreeView.class.getName() + DOT + "autoResizableW", String.valueOf(TreeView.AUTO_RESIZABLE_W_DEFAULT));
		attributeDefaultValues.put(TreeView.class.getName() + DOT + "boolSelActive", String.valueOf(TreeView.BOOL_SEL_ACTIVE_DEFAULT));
		attributeDefaultValues.put(TreeView.class.getName() + DOT + "draggable", String.valueOf(TreeView.DRAGGABLE_DEFAULT));
		attributeDefaultValues.put(TreeView.class.getName() + DOT + "draggableNode", String.valueOf(TreeView.DRAGGABLE_NODE_DEFAULT));
		attributeDefaultValues.put(TreeView.class.getName() + DOT + "withRoot", String.valueOf(TreeView.WITH_ROOT_DEFAULT));
		attributeDefaultValues.put(TreeView.class.getName() + DOT + "withT", String.valueOf(TreeView.WITH_T_DEFAULT));
		
		attributeDefaultValues.put(Window.class.getName() + DOT + "icone", String.valueOf(Window.ICONE_DEFAULT));
		attributeDefaultValues.put(Window.class.getName() + DOT + "title", String.valueOf(Window.TITLE_DEFAULT));
		attributeDefaultValues.put(Window.class.getName() + DOT + "style", String.valueOf(Window.STYLE_DEFAULT));
		attributeDefaultValues.put(Window.class.getName() + DOT + "top", String.valueOf(Window.TOP_DEFAULT));
		attributeDefaultValues.put(Window.class.getName() + DOT + "left", String.valueOf(Window.LEFT_DEFAULT));
	}
	
	public boolean suppressAttribute(AttributeDescriptor attributeDescriptor, String value) {
		if(attributeDescriptor.getPropertyName() != null && value != null
			&& isDefaultValue(attributeDescriptor.getPropertyName(), value)) {
			return true;
		}
		return false;
	}
	
	private boolean isDefaultValue(String attribute, String value) {
		String attributeKey = currentElement == null ? attribute : currentElement.getClass().getName() + DOT + attribute;
		return (attributeDefaultValues.containsKey(attributeKey) && value.equals(attributeDefaultValues.get(attributeKey)));
	}

    public boolean suppressElement(ElementDescriptor element, String namespaceUri, String localName, String qualifiedName, Object value) {
    	if (value instanceof MaskatElement) {
    		currentElement = (MaskatElement)value;
    		if (value instanceof Component) {
    			return !((Component)value).hasEnabledEvents();
    		}
    		if (value instanceof Desc) {
    			return ((Desc)value).getComment() == null;
    		}
    	}
    	return ValueSuppressionStrategy.DEFAULT.suppressElement(element, namespaceUri, localName, qualifiedName, value);
    }
}
