/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.betwixt;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.strategy.ValueSuppressionStrategy;
import org.maskat.core.MaskatElement;
import org.maskat.core.event.Bind;
import org.maskat.core.event.Component;
import org.maskat.core.event.Event;
import org.maskat.core.event.Param;
import org.maskat.core.event.RemoteUrl;
import org.maskat.core.event.Result;
import org.maskat.core.event.Source;
import org.maskat.core.event.Target;
import org.maskat.core.layout.Desc;

public class EventValueSuppressionStrategy extends ValueSuppressionStrategy {

	private static final String DOT = ".";
	
	private Map attributeDefaultValues = new HashMap();
	
	private MaskatElement currentElement = null;
	
	public EventValueSuppressionStrategy() {
		attributeDefaultValues.put(Bind.class.getName() + DOT + "sendBlankElement", String.valueOf(Bind.SEND_BLANK_ELEMENT_EDEFAULT));
		attributeDefaultValues.put(Event.class.getName() + DOT + "type", String.valueOf(Event.TYPE_DEFAULT));
		attributeDefaultValues.put(Event.class.getName() + DOT + "async", String.valueOf(Event.ASYNC_DEFAULT));
		attributeDefaultValues.put(Event.class.getName() + DOT + "timeout", String.valueOf(Event.TIMEOUT_DEFAULT));
		attributeDefaultValues.put(Param.class.getName() + DOT + "soap", String.valueOf(Param.SOAP_DEFAULT));
		attributeDefaultValues.put(Source.class.getName() + DOT + "sendBlankElement", String.valueOf(Source.SEND_BLANK_ELEMENT_DEFAULT));
		attributeDefaultValues.put(Source.class.getName() + DOT + "min", String.valueOf(Source.MIN_DEFAULT));
		attributeDefaultValues.put(Source.class.getName() + DOT + "max", String.valueOf(Source.MAX_DEFAULT));
		attributeDefaultValues.put(Source.class.getName() + DOT + "fromkey", String.valueOf(Source.FROM_KEY_DEFAULT));
		attributeDefaultValues.put(Target.class.getName() + DOT + "type", String.valueOf(Target.TYPE_DEFAULT));
		attributeDefaultValues.put(Result.class.getName() + DOT + "soap", String.valueOf(Result.SOAP_DEFAULT));
	}

	public boolean suppressAttribute(AttributeDescriptor attributeDescriptor, String value) {
		if(attributeDescriptor.getPropertyName() != null && value != null
			&& isDefaultValue(attributeDescriptor.getPropertyName(), value)) {
			return true;
		}
		return ValueSuppressionStrategy.DEFAULT.suppressAttribute(attributeDescriptor, value);
	}
	
	private boolean isDefaultValue(String attribute, String value) {
		String attributeKey = currentElement == null ? attribute : currentElement.getClass().getName() + DOT + attribute;
		return (attributeDefaultValues.containsKey(attributeKey) && value.equals(attributeDefaultValues.get(attributeKey)));
	}

    public boolean suppressElement(ElementDescriptor element, String namespaceUri, String localName, String qualifiedName, Object value) {
    	if (value instanceof MaskatElement) {
    		currentElement = (MaskatElement)value;
    		
    		if (value instanceof Event) {
    			return !((Event)value).isEnable();
    		}
    		if (value instanceof Component) {
    			return !((Component)value).hasEnabledEvents();
    		}
    		if (value instanceof RemoteUrl) {
    			return ((RemoteUrl)value).getUrl() == null || "".equals(((RemoteUrl)value).getUrl()); 
    		}
    		if (value instanceof Param) {
    			return !((Param)value).isEnable();
    		}
    		if (value instanceof Result) {
    			return !((Result)value).isEnable();
    		}
    		if (value instanceof Desc) {
    			return ((Desc)value).getComment() == null;
    		}
    	}
    	return ValueSuppressionStrategy.DEFAULT.suppressElement(element, namespaceUri, localName, qualifiedName, value);
    }
}
