/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core.betwixt;

import org.maskat.core.layout.custom.ComponentRegistry;
import org.maskat.core.layout.custom.DynaComponent;
import org.maskat.core.layout.custom.DynaComponentClass;
import org.maskat.core.layout.custom.DynaContainer;
import org.maskat.core.layout.custom.UnknownComponent;
import org.maskat.core.layout.custom.UnknownComponentClass;

import org.apache.commons.betwixt.io.read.BeanCreationChain;
import org.apache.commons.betwixt.io.read.BeanCreationList;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.ReadContext;

public class DynaBeanCreationChain extends BeanCreationChain {

	public Object create(ElementMapping elementMapping, ReadContext context) {
		Object bean = BeanCreationList.createDefaultChain().create(elementMapping, context);
		if (bean == null || bean instanceof DynaComponent) {
			try {
				Object dynaClass = ComponentRegistry.getComponentType(elementMapping.getNamespace(), elementMapping.getName());
				if (dynaClass == null) {
					//unknown component;
					bean = new UnknownComponent();
					dynaClass = new UnknownComponentClass(elementMapping.getName(), UnknownComponent.class, collectProperties(elementMapping));
					((UnknownComponent)bean).setDynaClass((UnknownComponentClass)dynaClass);
				} else {
					//customize component
					if (((DynaComponentClass)dynaClass).isContainer()) {
						bean = new DynaContainer();
					}
					bean = (bean == null) ? new DynaComponent() : bean;
					((DynaComponent)bean).setDynaClass((DynaComponentClass)dynaClass);
				}
				//update the attributeDescriptors of this element
//				context.getCurrentDescriptor().setAttributeDescriptors(
//						context.getXMLIntrospector().introspect((DynaComponent)o).getElementDescriptor().getAttributeDescriptors());
				//populateAttributes here.
				context.pushBean(bean);
				context.populateAttributes(context.getXMLIntrospector().introspect(bean).getElementDescriptor().getAttributeDescriptors(),
						elementMapping.getAttributes());
				context.popBean();
			} catch (Exception e) {
				// TODO Auto-generated catch block
//				e.printStackTrace();
			}
		}
		return bean;
	}
	
	private String[] collectProperties(ElementMapping elementMapping) {
		if (elementMapping == null || elementMapping.getAttributes() == null 
				|| elementMapping.getAttributes().getLength() == 0) {
			return new String[]{};
		}
		
		String[] properties = new String[elementMapping.getAttributes().getLength()];
		for (int i=0; i<properties.length; i++) {
			properties[i] = elementMapping.getAttributes().getQName(i);
		}
		return properties;
	}
}
