/*
 * Copyright (c) 2006-2008 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package org.maskat.core;

import java.util.Iterator;

/**
 * 定義XMLファイルの要素オブジェクトに対して、
 * 子要素のiteratorとして使われる。
 * 子要素の削除とともに、BasicDefのchildrenから子要素を削除する
 */
public class DefChildIterator implements Iterator {

	private MaskatElement basicDef;

	private Iterator it;

	private Object current = null;

	/** カレントエレメントはremoveされたかフラグ */
	boolean removed = false;

	public DefChildIterator(MaskatElement basicDef, Iterator it) {
		this.basicDef = basicDef;
		this.it = it;
	}

	public void remove() {
		if (removed == true) {
			return;
		}
		basicDef.removeChild(current);
		it.remove();
		current = null;
		removed = true;
	}

	public boolean hasNext() {
		return it.hasNext();
	}

	public Object next() {
		current = it.next();
		removed = false;
		return current;
	}

}
