/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.schema;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.schema.GlobalComplexType;
import org.apache.commons.betwixt.schema.GlobalElement;
import org.apache.commons.betwixt.schema.SimpleType;
import org.apache.commons.betwixt.schema.TranscriptionConfiguration;

public class Schema {
    private List elements = new ArrayList();
    private List complexTypes = new ArrayList();
    private List simpleTypes = new ArrayList();
    private XMLIntrospector introspector;

    public Schema() {
        this(new XMLIntrospector());
    }

    public Schema(XMLIntrospector introspector) {
        this.introspector = introspector;
    }

    public XMLBeanInfo introspect(Class type) throws IntrospectionException {
        return this.introspector.introspect(type);
    }

    public List getComplexTypes() {
        return this.complexTypes;
    }

    public void addComplexType(GlobalComplexType complexType) {
        this.complexTypes.add(complexType);
    }

    public List getElements() {
        return this.elements;
    }

    public void addElement(GlobalElement element) {
        this.elements.add(element);
    }

    public List getSimpleTypes() {
        return this.simpleTypes;
    }

    public void addSimpleType(SimpleType simpleType) {
        this.simpleTypes.add(simpleType);
    }

    public void addGlobalElementType(TranscriptionConfiguration configuration, ElementDescriptor elementDescriptor) throws IntrospectionException {
        GlobalElement element = new GlobalElement(elementDescriptor.getLocalName(), configuration.getSchemaTypeNamingStrategy().nameSchemaType(elementDescriptor));
        this.addElement(element);
        this.addGlobalComplexType(configuration, elementDescriptor);
    }

    public GlobalComplexType addGlobalComplexType(TranscriptionConfiguration configuration, ElementDescriptor elementDescriptor) throws IntrospectionException {
        GlobalComplexType type = null;
        Iterator it = this.complexTypes.iterator();
        while (it.hasNext()) {
            GlobalComplexType complexType = (GlobalComplexType)it.next();
            if (!complexType.matches(elementDescriptor)) continue;
            type = complexType;
            break;
        }
        if (type == null) {
            type = new GlobalComplexType(configuration, elementDescriptor, this);
            this.addComplexType(type);
            type.fill(configuration, elementDescriptor, this);
        }
        return type;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Schema) {
            Schema schema = (Schema)obj;
            result = this.equalContents(this.elements, schema.elements) && this.equalContents(this.complexTypes, schema.complexTypes) && this.equalContents(this.simpleTypes, schema.simpleTypes);
        }
        return result;
    }

    private boolean equalContents(Collection one, Collection two) {
        if (one.size() != two.size()) {
            return false;
        }
        Iterator it = one.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (two.contains(object)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>");
        buffer.append("<xsd:schema xmlns:xsd='http://www.w3c.org/2001/XMLSchema'>");
        Iterator it = this.simpleTypes.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        it = this.complexTypes.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        it = this.elements.iterator();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        buffer.append("</xsd:schema>");
        return buffer.toString();
    }
}

