# -*- coding: utf-8 -*-

#########################################################################
## - Application Name: Machikane-Red
## - Version: 3.1910
## - Date: 2019-10-19
## - Copyright: (c) 2018-2019 Mitsuhiro Tsuda.
## - License: Machikane-Red (version 3) is released
##            under the GNU General Public License (GPL).
##            See the copyright notice LICENSE.
#########################################################################

import os
import io
import datetime
import random
import re
import json
import urllib
from gluon.sanitizer import sanitize
#import jaconv


mr_datahelper = local_import('mr_datahelper', reload=MR_CONF['RELOAD'])
mr_helper = local_import('mr_helper', reload=MR_CONF['RELOAD'])
mr_manifesthelper = local_import('mr_iiifmanifesthelper', reload=MR_CONF['RELOAD'])


# ========================================
# Main controllers
# ========================================

def index():
    """
    トップ
    """
    if session is not None:
        session.auth = None
        session.group = None

    # 引数（ページID）の取得
    pageid = 1  #デフォルト
    if len(request.args) > 0:
        pageid = request.args(0, cast=int) or 1

    # ページの内容（ページ・セクション）一覧
    # ページがpageidであるページセクション（複数）の取得
    da = mr_datahelper.d_d_page(dbm, pageid)

    div_main = DIV(_class='main m-content')

    for d_d in da['array']:

        div_section = TAG.section(
                        DIV(
                            *[P(mr_helper.__helper_br(v['value']),_class='') for v in d_d['description']]
                        ),
                        _class='m-page-section m-index-section'
                    )
        div_main.append(div_section)

    ## メニュー索引の作成
    #ul_menu = __get_topmenu()

    # サイドメニュー索引の作成
    ul_menu = __get_sidemenu()
    
    return dict(menu=ul_menu, main=div_main)


def wiki():
    #auth.wikimenu() # add the wiki to the menu
    return auth.wiki()


def page():
    """
    ページ
    """
    # 引数（ページID）の取得
    pageid = 1  #デフォルト
    if len(request.args) > 0:
        pageid = request.args(0, cast=int) or 1

    # ページ指定（内容＝セクション）一覧
    # ページがpageidであるページセクション（複数）の取得
    da = mr_datahelper.d_d_page(dbm, pageid)

    div_main = DIV(_class='main m-content')

    for d_d in da['array']:

        div_section = TAG.section(
                        *[H2(mr_helper.__helper_br(v['value'])) for v in d_d['title']],
                        DIV(
                            *[P(mr_helper.__helper_br(v['value']),_class='') for v in d_d['description']]
                        ),
                        DIV(
                            SPAN(T(d_d['date'][0]['label']),': ',XML(d_d['date'][0].get('value','')) or XML('&mdash;'))
                            ,XML('&nbsp'),'|',XML('&nbsp;'),SPAN(T(d_d['creator'][0]['label']),': ',XML(d_d['creator'][0].get('value','')) or XML('&mdash;')),
                            _class='m-page-section-info'
                        ),
                        _class='m-page-section'
                    )
        div_main.append(div_section)

    # サイドメニュー索引の作成
    ul_sidemenu = __get_sidemenu()

    return dict(sidemenu=ul_sidemenu, main=div_main)


def __form_search(v_offset):
    """
    検索フォーム（最小）
    """
    form = FORM(
                DIV(
                    DIV(
                        DIV(
                            DIV(
                                INPUT(
                                    _type='checkbox',
                                    _name='cross',
                                    _value='0',
                                    value=False,
                                    _class='form-check-input'
                                ),
                                LABEL(
                                    T('Cross search'),
                                    _class='form-check-label ml-2'
                                ),
                                _class='form-check form-check-inline text-left w-100'
                            ),
                            _class='col-12 col-sm-2 px-2 my-2'
                        ),
                        DIV(
                            INPUT(
                                _type='search',
                                _placeholder=T('Search words'),
                                _name='q',
                                _class='form-control w-100'
                            ),
                            _class='col-9 col-sm-7 px-2'
                        ),
                        DIV(
                            TAG.button(
                                I(_class='fa fa-search',**{'_aria-hidden':'true'}),' ',
                                SPAN(T('Search'),_class='d-none d-sm-inline'),
                                _type='button',
                                _name='dosearch',
                                _class='btn btn-primary w-100'
                            ),
                            _class='col-3 col-sm-3 px-2'
                        ),
                        _class='row formgroup'
                    ),
                    _class='container'
                ),
                hidden=dict(wi='0',offset=v_offset),
                _method='POST',
                _class='form-inline',
            )

    return form


def __pager(count, var_offset, var_limit, var_from, var_args=None, var_wid=0, keys=None):
    """
    ページネーション
    """
    PAGE_LIM = 3
    a_block = count // var_limit
    if count % var_limit > 0: a_block += 1
    pager = [x for x in range(0, a_block)]
    pager.insert(0, var_offset // var_limit)

    #jtx = lambda x : URL(f=var_from,args=var_args,vars=dict(offset=str(var_limit*x)))
    jtx = lambda x : "javascript:pager(%d)" % (var_limit*x,)

    # Previous
    var_prev = pager[0] - 1
    var_prev10 = pager[0] - 10
    if var_prev < 0:
        var_prev = 0
        var_prev10 = 0
        item_prev=LI(I('',_class='fa fa-caret-left fa-lg'),_id='m-pagerPrev',_class='m-pager-hidden1 m-pager-tl')
        item_prev10=LI(I('',_class='fa fa-backward'),_id='m-pagerPrev10',_class='m-pager-hidden1 m-pager-tl')
        item_first=LI(I('',_class='fa fa-step-backward'),_id='m-pagerFirst',_class='m-pager-hidden1 m-pager-tl')
    else:
        item_prev=LI(A(I('',_class='fa fa-caret-left fa-lg'),_href=jtx(var_prev)),_id='m-pagerPrev',_class='m-pager-tl')
        if var_prev10 < 0:
            var_prev10 = 0
            item_prev10=LI(I('',_class='fa fa-backward'),_id='m-pagerPrev10',_class='m-pager-hidden1 m-pager-tl')
        else:
            item_prev10=LI(A(I('',_class='fa fa-backward'),_href=jtx(var_prev10)),_id='m-pagerPrev10',_class='m-pager-tl')
        item_first=LI(A(I('',_class='fa fa-step-backward'),_href=jtx(0)),_id='m-pagerFirst',_class='m-pager-tl')

    # Next
    var_next = pager[0] + 1
    var_next10 = pager[0] + 10
    if var_next > pager[-1]:
        var_next = pager[-1]
        var_next10 = pager[-1]
        item_next=LI(I('',_class='fa fa-caret-right fa-lg'),_id='m-pagerNext',_class='m-pager-hidden1 m-pager-tl')
        item_next10=LI(I('',_class='fa fa-forward'),_id='m-pagerNext10',_class='m-pager-hidden1 m-pager-tl')
        item_last=LI(I('',_class='fa fa-step-forward'),_id='m-pagerLast',_class='m-pager-hidden1 m-pager-tl')
    else:
        item_next=LI(A(I('',_class='fa fa-caret-right fa-lg'),_href=jtx(var_next)),_id='m-pagerNext',_class='m-pagertl')
        if var_next10 > pager[-1]:
            var_prev10 = pager[-1]
            item_next10=LI(I('',_class='fa fa-forward'),_id='m-pagerNext10',_class='m-pager-hidden1 m-pager-tl')
        else:
            item_next10=LI(A(I('',_class='fa fa-forward'),_href=jtx(var_next10)),_id='m-pagerNext10',_class='m-pager-tl')
        item_last=LI(A(I('',_class='fa fa-step-forward'),_href=jtx(pager[-1])),_id='m-pagerLast',_class='m-pager-tl')

    ys = 1    # shift
    y = pager[0]
    ye = PAGE_LIM + 1

    if y > PAGE_LIM - 1:
        ys = y - (PAGE_LIM - 3) // 2
        ye = ys + PAGE_LIM
        if ye > len(pager): ys = len(pager) - PAGE_LIM

    if ys > 1:
        item_prev_over=LI(DIV(XML('&hellip;')),_class='m-pager-off m-pager-tl')
    else:
        item_prev_over=LI('',_class='m-pager-off')

    if len(pager)>ye:
        item_next_over=LI(DIV(XML('&hellip;')),_class='m-pager-off m-pager-tl')
    else:
        item_next_over=LI('',_class='m-pager-off')

    pageritem = UL(
            item_first,
            item_prev10,
            item_prev,
            item_prev_over,
            [LI(A(DIV(str(x + 1)),_href=jtx(x))) for x in pager[ys:y + 1]],
            LI(DIV(str(y + 1)),_class='m-pager-current'),
            [LI(A(DIV(str(x + 1)),_href=jtx(x))) for x in pager[y + 2:ye]],
            item_next_over,
            item_next,
            item_next10,
            item_last,
            _id='mPager',**{'_data-current':y,'_data-index':str(var_offset),'_data-count':str(count)}
        )

    return (pager, pageritem)


def items():
    """
    アイテム・リスト
    """
    # 引数（コレクションID）の取得
    collid = 0  #デフォルト
    if len(request.args) > 0:
        collid = request.args(0, cast=int) or 0

    # 変数
    var_offset = 0
    var_limit = 20
    var_wid = 0

    l_query = []
    var_cross = 1

    count = 0
    count_all = 0

    pager = None
    pageritem = None

    if request.vars:
        var_offset = int(request.vars.get('offset') or 0)
        #var_limit = int(request.vars.get('limit') or 20)
        var_wid = int(request.vars.get('wi') or 0)

    form = __form_search(var_offset)

    if form.accepts(request, session, keepvalues=True):
        #response.flash = T('form accepted')
        l_query = sanitize(form.vars.get('q')).split()
        var_cross = int(form.vars.get('cross') or 1)

    elif form.errors:
        response.flash = T('form has errors')
    else:
        #response.flash = T('please fill the form')
        pass

    # コレクション指定リソース一覧
    da = mr_datahelper.d_d_finder(dbm, collid * var_cross, l_query, False, var_offset, var_limit)

    session.imgs = {}

    # 移動
    session.moves = None
    l_moves = []

    # コレクションがcollidであるリソース（複数）の取得
    div_main = DIV(_class='main m-content')

    count_all = da['result']['all']

    if len(da['array']) > 0:

        count = len(da['array'])
        (pager, pageritem) = __pager(count_all, var_offset, var_limit, 'items', request.args, var_wid)

        for d_d in da['array']:

            dl_meta = TAG.dl()
            for ky in d_d['keyset']:
                if not ky in ['title','description']:
                    if ky in d_d and d_d[ky]['value'] is not None:
                        dl_meta.append(TAG.dt(d_d[ky].get('label',T('(Undefined)'))))
                        dl_meta.append(TAG.dd(mr_helper.__helper_br(d_d[ky].get('value',''))))

            imgs = __image_ul_for_items(session, d_d)

            if imgs:

                div_resource = DIV(
                            DIV(
                                imgs,
                                _class='col-12 col-sm-6 col-md-5 text-center'
                            ),
                            DIV(
                                H2(
                                    A(d_d['title'].get('value',''),
                                        _href=URL('item',args=[d_d['subid']])
                                    ),
                                    _class='m-title'
                                ),
                                DIV(
                                    P(mr_helper.__helper_br(d_d['description'].get('value',['']))),
                                    dl_meta
                                ),
                                _class='col-12 col-sm-6 col-md-7 mt-3 mt-sm-2'
                            ),
                            _class='row m-resource-item m-resource-block'
                        )

            else:

                div_resource = DIV(
                            DIV(
                                H2(
                                    A(d_d['title'].get('value',''),
                                        _href=URL('item',args=[d_d['subid']])
                                    ),
                                    _class='m-title'
                                ),
                                DIV(
                                    P(mr_helper.__helper_br(d_d['description'].get('value',['']))),
                                    dl_meta
                                ),
                                _class='col'
                            ),
                            _class='row m-resource-item m-resource-block'
                        )

            div_main.append(div_resource)

            l_moves.append(d_d['subid'])

    else:

        div_resource = DIV(
                    DIV(
                        P(T('No result.')),
                        _class='col'
                    ),
                    _class='row m-resource-item m-resource-block'
                )

        div_main.append(div_resource)
        pageritem = ''

    session.moves = l_moves
    session.dbparams = [collid,var_offset]

    # サイドメニュー索引の作成
    ul_sidemenu = __get_sidemenu()

    return dict(sidemenu=ul_sidemenu, main=div_main, form=form, pager=pager, pageritem=pageritem, result=[var_offset + 1, var_offset + count, count, count_all], q=da['result']['q'] or [])


def item():
    """
    リソース・アイテム
    """
    # 引数（リソースID）の取得
    resourceid = 1  #デフォルト
    if len(request.args) > 0:
        resourceid = request.args(0, cast=int) or 1

    var_collid = 1
    var_offset = 0

    # リソース
    da = mr_datahelper.d_d_resource(dbm, resourceid)

    session.imgs = {}

    # リソースがresourceidであるリソースアイテム（複数）の取得
    div_main = DIV(_class='main m-content')

    for d_d in da['array']:

        imgs = __image_ul_for_eachitem(session, d_d, ['area'], True) or ''

        div_resource = DIV(
                            H2(d_d['title'].get('value','')),
                            DIV(
                                P(mr_helper.__helper_br(d_d['description'].get('value','')))
                            ),
                            imgs,
                            DIV(
                                TABLE(*[
                                    TR(TD(d_d[ky]['label'], _class='m-label'),TD(mr_helper.__helper_br(d_d[ky].get('value','')))) for ky in d_d['keyset']
                                    if (ky not in ('title','description')) and (ky in d_d) and (d_d[ky]['value'] is not None)
                                ])
                            ),
                            DIV(
                                __get_table_external_attributions(d_d)   # 外部Manifest対応
                            ),
                            _class='m-resource-item'
                        )

        div_main.append(div_resource)

    # 移動
    span_prev = SPAN(T('Prev.'))
    span_next = SPAN(T('Next'))

    if session.moves:
        l_moves = session.moves
        idx = l_moves.index(resourceid)
        if idx > 0:
            span_prev = A(SPAN(T('Prev.')),_href=URL('item',args=[l_moves[idx-1]]))
        if idx < len(l_moves) - 1:
            span_next = A(SPAN(T('Next')),_href=URL('item',args=[l_moves[idx+1]]))

    if session.dbparams:
        [var_collid, var_offset] = session.dbparams

    # サイドメニュー索引の作成
    ul_sidemenu = __get_sidemenu()

    return dict(sidemenu=ul_sidemenu, main=div_main, prev=span_prev, next=span_next, collectionid=var_collid)


def viewer():
    """
    画像表示
    """
    var_r_id = 1
    var_folder_id = 1
    var_f_id = 1
    var_a_id = 0
    var_ids = [1,1,1,1]
    var_external = False

    var_target = tuple(request.args)

    if var_target in session.imgs:
        var_ids = session.imgs[var_target]
        (var_r_id,var_folder_id,var_f_id,var_a_id) = var_ids

    var_manifest = None
    var_f_manifest = ''

    var_folder = None
    var_name = None
    var_format = None

    var_on_annote = False

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            # IIIF Manifest
            if request.args[1]=='external':
                r_row = dbm.mr_resources[var_r_id]
                if r_row.mr_manifest_id:
                    var_manifest = r_row.mr_manifest_id
                else:
                    var_manifest = r_row.mr_manifest_link
                var_external = True
            else:
                var_manifest = '/'.join(request.args)
        else:
            var_folder = sanitize(request.args(0))
            var_name = sanitize(request.args(1))
            var_format = sanitize(request.args(2))
        if 'annote' in request.args:
            var_on_annote = True

    return dict(vmanifest=var_manifest, vfolder=var_folder, vname=var_name, vformat=var_format, preview=UL(), subview=UL(), infoview='', idset=var_ids, external=var_external)


def viewer_mirador():
    """
    画像表示
    Mirador Viewer（Experimantal)
    """
    var_external = False

    var_manifest = None

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            var_manifest = '/'.join(request.args)

    return dict(vmanifest=var_manifest, external=var_external)


def viewer_lflt():
    """
    画像表示
    Leaflet IIIF Viewer（Experimantal)
    """
    var_external = False

    var_manifest = None

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            var_manifest = '/'.join(request.args)

    return dict(vmanifest=var_manifest, external=var_external)


def viewer_osdg():
    """
    画像表示
    OpenSeadragon Viewer（Experimantal)
    """
    var_external = False

    var_manifest = None

    if request.args and len(request.args) > 2:
        if request.args[-1] == 'manifest.json':
            var_manifest = '/'.join(request.args)

    return dict(vmanifest=var_manifest, external=var_external)


# ========================================
# Menu
# ========================================

def __get_topmenu():
    """
    Menuを取得する
    """
    ul = UL(_class='col list-inline d-flex flex-wrap w-100 m-0 p-0 m-menu-top')

    #li = LI(A(T('Home'),_href=URL('index')),_class="list-group-item m-menu-top-item")
    #ul.append(li)

    for r in dbm((dbm.mr_collections._id>1)&(dbm.mr_collections.mr_open==True)).select(orderby=[dbm.mr_collections.mr_order,dbm.mr_collections.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('items',args=[str(r.id)])),_class="list-group-item m-menu-top-item")
        ul.append(li)

    for r in dbm((dbm.mr_pages._id>1)&(dbm.mr_pages.mr_open==True)).select(orderby=[dbm.mr_pages.mr_order,dbm.mr_pages.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('page',args=[str(r.id)]),_class=""),_class="list-group-item m-menu-top-item")
        ul.append(li)

    return ul


def __get_sidemenu():
    """
    Side menuを取得する
    """
    ul = UL(_class='list-group list-group-flush m-menu')

    #li = LI(A(T('Home'),_href=URL('index')),_class="list-group-item")
    #ul.append(li)

    for r in dbm((dbm.mr_collections._id>1)&(dbm.mr_collections.mr_open==True)).select(orderby=[dbm.mr_collections.mr_order,dbm.mr_collections.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('items',args=[str(r.id)])),_class="list-group-item")
        ul.append(li)

    for r in dbm((dbm.mr_pages._id>1)&(dbm.mr_pages.mr_open==True)).select(orderby=[dbm.mr_pages.mr_order,dbm.mr_pages.id]):
        li = LI(A('%s' % r.mr_title,_href=URL('page',args=[str(r.id)]),_class=""),_class="list-group-item")
        ul.append(li)

    return ul


# ========================================
# IIIF Manifest
# ========================================

def iiif():
    """
    IIIF Presentation API 2.1
    """
    # 引数（リソースID/アノートID）の取得
    resourceid = 1  # Default
    folderid = 1  # Default
    fileid = 1  # Default
    annoteid = 1  # Default
    req_api_type = 'manifest.json'
    if len(request.args) > 1:
        domain = sanitize(request.args(0))
        if domain == 'annote':
            annoteid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'file':
            fileid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'folder':
            folderid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        elif domain == 'resource':
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))
        else:
            domain = 'resource'
            resourceid = request.args(1, cast=int) or 1
            if len(request.args) > 2:
                req_api_type = sanitize(request.args(-1))

    if req_api_type.startswith('manifest'):

        if domain == 'annote':
            da = mr_datahelper.d_d_annote(dbm, annoteid)
        elif domain == 'file':
            da = mr_datahelper.d_d_file(dbm, fileid)
        elif domain == 'folder':
            da = mr_datahelper.d_d_folder(dbm, folderid)
        else:
            da = mr_datahelper.d_d_resource(dbm, resourceid)

        # get Manifest JSON
        json_ld = mr_manifesthelper.__get_iiif_manifest(MR_CONF, da['array'])

        #return response.json(json_ld)
        return json.dumps(json_ld, ensure_ascii=False)

    elif req_api_type.startswith('annotationlist'):

        if domain == 'resource':
            cvid = None
            if 'cvid' in request.vars:
                cvid = request.vars.get('cvid')

            da = mr_datahelper.d_d_canvas(dbm, cvid, resourceid)

        #elif domain == 'file':
        #    da = mr_datahelper.d_d_file(dbm, fileid)
        else:
            da = mr_datahelper.d_d_file(dbm, fileid)

        # get Annotation List JSON
        json_ld = mr_manifesthelper.__get_iiif_annotationlist(MR_CONF, da['array'])

        #return response.json(json_ld)
        return json.dumps(json_ld, ensure_ascii=False)

    else:
        return response.json({})


# ========================================
# Manifest link
# ========================================

def __get_dom_icon_manifest(d_d):
    """
    Manifest link
    """
    a_href = ['iiif',d_d['role'],str(d_d['subid']),'manifest.json']
    a_manifest = SPAN(A(
        IMG(
            _src=URL('static','mr_images/iiif_logo.png'),
            _width='32'
        ),
        _href=URL('iiif',args=[d_d['role'],d_d['subid'],'manifest.json']),
        _target='_blank',
        _title='IIIF-Manifest'
        ),
        _class="m-manifest-link")

    return (a_manifest, a_href)


def __get_dom_icon_manifest_external(d_d):
    """
    Manifest link
    """
    a_href = ['iiif','external',str(d_d['ids'][0]),'manifest.json']
    a_manifest = SPAN(A(
        IMG(
            _src=URL('static','mr_images/iiif_logo.png'),
            _width='32'
        ),
        _href='%s://%s%s' % (d_d['href'][0],d_d['href'][1],d_d['href'][2]),
        _target='_blank',
        _title='IIIF-Manifest'
        ),
        _class="m-manifest-link")

    return (a_manifest, a_href, '%s://%s%s' % (d_d['href'][0],d_d['href'][1],d_d['href'][2]))


# ========================================
# Viewer icon
# ========================================

def __test_format(fcontains, refs):
    """
    フォーマットの含有テスト
    """
    b = False
    for v in fcontains:
        if v in refs:   #参照
            b = True
            break;
    return b


def __get_shimakuma_icon(fcontains, m_href_args):
    """
    Shimakuma link
    """
    if __test_format(fcontains, ('tif','jp2','jpg','fzp','fzp3','dzi','zoomify','external',)):
        a_viewer = SPAN(A(
            IMG(
                _src=URL('static','mr_libs/shimakuma/shimakuma-logo.png'),
                _width='30',_height='30'
            ),
            _href=URL('viewer',args=m_href_args),
            _target='_blank',
            _title='Shimakuma viewer'
            ),
            _class="m-viewer-link m-viewer-link-dark")
    else:
        a_viewer = ''

    return a_viewer


def __get_mirador_icon(fcontains, m_href_args):
    """
    Mirador link (Experimental)
    """
    if __test_format(fcontains, ('tif','jpg','external',)):
        a_viewer = SPAN(A(
            IMG(
                _src=URL('static','mr_libs/mirador/mirador-logo.png'),
                _width='30',_height='30'
            ),
            _href=URL('viewer_mirador',args=m_href_args),
            _target='_blank',
            _title='Mirador viewer'
            ),
            _class="m-viewer-link m-viewer-link-dark")
    else:
        a_viewer = ''

    return a_viewer


def __get_leaflet_icon(fcontains, m_href_args):
    """
    Leaflet IIIF link (Experimental)
    """
    if __test_format(fcontains, ('tif',)):
        a_viewer = SPAN(A(
            IMG(
                _src=URL('static','mr_libs/leaflet/temp.png'),
                _width='30',_height='30'
            ),
            _href=URL('viewer_lflt',args=m_href_args),
            _target='_blank',
            _title='Leaflet viewer'
            ),
            _class="m-viewer-link")
    else:
        a_viewer = ''

    return a_viewer


def __get_osdg_icon(format, m_href_args):
    """
    OpenSeadragon link (Experimental)
    """
    if __test_format(fcontains, ('tiff',)):
        a_viewer = SPAN(A(
            IMG(
                _src=URL('static','mr_libs/openseadragon/logo.png'),
                _width='30',_height='30'
            ),
            _href=URL('viewer_osdg',args=m_href_args),
            _target='_blank',
            _title='OpenSeadragon viewer'
            ),
            _class="m-viewer-link")
    else:
        a_viewer = ''

    return a_viewer


# ========================================
# Thumbnail image
# ========================================

def __image_ul_for_eachitem(_session, d_d, _atypes=['area'], enable_link=False):
    """
    Thumbnail imageのHTML(UL)を生成、item用
    """
    ul_file = None

    if 'folders' in d_d and len(d_d['folders'])>0:

        ul_file = UL(_class='m-image-items')

        for d_fd in d_d['folders']:

            for idx in d_fd.get('tops',[]):

                d_f = d_fd['files'][idx]

                if 'external' in d_fd['role']:

                    # Manifest link
                    (a_manifest,m_href_args,m_href) = __get_dom_icon_manifest_external(d_f)

                    # Snap image
                    img = IMG(_src='/'.join(d_f.get('snapimage','')),
                            #_width=240,
                            _alt=d_f['title'],
                            _class='m-snapimage'
                        )

                else:
                    # Manifest link
                    (a_manifest,m_href_args) = __get_dom_icon_manifest(d_fd)

                    # Snap image
                    img = IMG(_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f.get('snapimage',''))),
                            #_width=240,
                            _alt=d_f['title'],
                            _class='m-snapimage'
                        )

                if 'external' in d_fd['role']:
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']
                    d_f['format'] = 'external'

                elif d_fd['role']=='folder':
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                elif 'pdf' in d_f['href']:
                    href = '%s/resources/%s.pdf' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f['href'][:-1]))
                    _session.imgs[tuple(d_f['href'])] = d_f['ids']

                else:
                    #href = URL('viewer',args=d_f['href'])
                    href = URL('viewer',args=m_href_args)
                    _session.imgs[tuple(m_href_args)] = d_fd['ids']

                li_file = LI(
                                DIV(
                                    DIV(
                                        A(img,
                                            _href=href,
                                            _target='_blank',
                                            _title=d_f['title']
                                        ),
                                        a_manifest,
                                        _label=d_f['title'],
                                        _class='m-image m-image-snapimage',
                                        **{'_data-id':d_f['subid']}
                                    ),
                                    P(
                                        d_f['title']
                                    ),
                                    DIV(
                                        __get_shimakuma_icon([d_f['format']], m_href_args),
                                        __get_mirador_icon([d_f['format']], m_href_args),
                                        #__get_leaflet_icon([d_f['format']], m_href_args),
                                        #__get_osdg_icon([d_f['format']], m_href_args),
                                    )
                                ),
                                _class='m-image-item m-image-item-wid320'
                            )

                ul_file.append(li_file)


                # セグメント
                if 'annotes' in d_f and len(d_f['annotes'])>0:

                    for d_a in d_f['annotes']:

                        # 対象のアノテーション形式（デフォルト'area'）以外はスルー（出力抑制）
                        if d_a['annotetype'] not in _atypes: continue

                        # Manifest link
                        (a_manifest,m_href_args) = __get_dom_icon_manifest(d_a)

                        # Snap image
                        if 'tif' in d_f['format'] or 'jp2' in d_f['format']:
                            img_src = '%s%s.%s/%s/240,/%d/default.jpg' % (MR_CONF['IIIF_SERVER_URL'],'%2F'.join(d_f['href'][:-1]),d_f['format'],','.join([str(v) for v in d_a['annotearea']]),int(d_a['annoterotation']))
                        elif 'jpg' in d_f['format']:
                            img_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_a['thumbnail']))
                        else:
                            continue

                        img = IMG(_src=img_src,
                                    _alt=d_a['title'],
                                    _class='m-thumbnail'
                                )
                        href = URL('viewer',args=d_a['href'])
                        var_args = d_f['href']
                        if 'tif' in d_f['format'] or 'jp2' in d_f['format']:
                            manifest_id = "iiif/annote/%s/manifest.json" % (str(d_a['subid']))
                            var_args = ['iiif','annote',str(d_a['subid']),'manifest.json']
                            href = URL('viewer',args=[manifest_id])

                        if enable_link:
                            img_obj = A(img,
                                        _href=href,
                                        _target='_blank',
                                        _title=d_a['title']
                                    )
                        else:
                            img_obj = img

                        _session.imgs[tuple(var_args)] = d_a['ids']

                        li_file = LI(
                                        DIV(
                                            DIV(img_obj,
                                                a_manifest,
                                                _label=d_a['title']['value'],
                                                _class='m-image m-image-thumbnail',
                                                **{'_data-id':d_a['subid']}
                                            ),
                                            P(
                                                d_a['title']['value']
                                            ),
                                            DIV(
                                                __get_shimakuma_icon([d_f['format']], m_href_args),
                                                __get_mirador_icon([d_f['format']], m_href_args),
                                                #__get_leaflet_icon([d_f['format']], m_href_args),
                                                #__get_osdg_icon([d_f['format']], m_href_args),
                                            )
                                        ),
                                        _class='m-image-item m-image-item-wid160'
                                    )

                        ul_file.append(li_file)

    return ul_file


def __image_ul_for_items(_session, d_d):
    """
    Thumbnail imageのHTML(UL)を生成
    """
    ul_file = None

    if 'folders' in d_d and len(d_d['folders'])>0:

        ul_file = UL(_class='m-image-items')

        for d_fd in d_d['folders']:

            for idx in d_fd.get('tops',[0]):

                d_f = d_fd['files'][idx]

                if 'role' in d_f and d_f['role'].startswith('external'):

                    # Thumbnail image
                    img = IMG(_src=d_f.get('thumbnailuri',''),
                                _alt=d_f['title'],
                                _class='m-thumbnail',
                            )

                    href = URL('item',args=[d_d['subid']])

                    #_session.imgs[] = d_f['ids']

                else:

                    # Thumbnail image
                    img = IMG(_src='%s/resources/%s' % (MR_CONF['SERVER_IMAGE_URL'],'/'.join(d_f.get('thumbnail',''))),
                                _alt=d_f['title'],
                                _class='m-thumbnail'
                            )

                    href = URL('item',args=[d_d['subid']])

                    _session.imgs[tuple(d_f['href'])] = d_f['ids']

                li_file = LI(
                                DIV(
                                    A(img,
                                        _href=href
                                    ),
                                    _label=d_f['title'],
                                    _class='m-image m-image-thumbnail',
                                    **{'_data-id':d_f['subid']}
                                ),
                                P(
                                    d_f['title'],
                                    _class='d-none d-sm-block'
                                ),
                                _class='m-image-item m-image-item-wid160'
                            )

                ul_file.append(li_file)

    return ul_file


# ========================================
# External contents
# ========================================

def __get_table_external_attributions(d_d):
    """
    外部マニフェスト属性テーブル
    """
    table = None

    if d_d['role'].startswith('external'):

        table = TABLE(TR(TD(T('from Manifest'),_colspan='2',_class='m-label m-label-header')),_class='col')

        for ky in d_d['externalkeyvalue']:
            if ky in d_d['keyset']:
                continue
            if isinstance(d_d['externalkeyvalue'][ky],list):

                for d in d_d['externalkeyvalue'][ky]:
                    if d and len(d.strip())>0:
                        tr = TR(
                                TD(ky, _class='m-label'),
                                TD(XML(d))
                            )
                        table.append(tr)

            elif isinstance(d_d['externalkeyvalue'][ky],str):
                if len(d_d['externalkeyvalue'][ky].strip())>0:
                    tr = TR(
                                TD(ky, _class='m-label'),
                                TD(d_d['externalkeyvalue'][ky])
                            )

                    table.append(tr)

    return table or ''


# ========================================
# User
# ========================================

def user():
    """
    ユーザー認証
    """
    session = None
    auth.settings.controller = 'default'
    return dict(form=auth())
