package method.tsp;

import java.util.Comparator;
import method.GraphDemonstration;
import tsp.Node;
import util.HeapSet;
import view.DemoPanel;

public class OneTree implements GraphDemonstration {
	public void method(DemoPanel panel) {
		final Node[] nodes = panel.getNodes().toArray(new Node[]{});
		boolean[][] edges = new boolean[nodes.length][nodes.length];
		if (nodes.length > 1) {
			Edge e;
			boolean[] close = new boolean[nodes.length];
			HeapSet<Edge> open = new HeapSet<Edge>(11, new Comparator<Edge>() {
				public int compare(Edge o1, Edge o2) {
					double diff = nodes[o1.s].getDistance(nodes[o1.t]) - nodes[o2.s].getDistance(nodes[o2.t]);
					if (diff > 0) {
						return 1;
					} else if (diff < 0) {
						return -1;
					} else {
						return 0;
					}
				}
			});

			int s = (int) (Math.random() * nodes.length);
			close[s] = true;
			int index = (s + 1) % nodes.length;
			close[index] = true;
			do {
				for (int i = 0; i < nodes.length; i++) {
					if (i != index) {
						if (!close[i]) {
							open.add(new Edge(index, i));
						}
					}
				}
				e = open.poll();
				if (e == null) {
					break;
				}
				if (!close[e.t]) {
					edges[e.s][e.t] = true;
					index = e.t;
					close[index] = true;
					panel.set(edges);
				}
			} while (open.size() > 0);
			open.clear();
			for (int i = 0; i < nodes.length; i++) {
				if (s != i) {
					open.add(new Edge(s, i));
				}
			}
			e = open.poll();
			edges[e.s][e.t] = true;
			e = open.poll();
			edges[e.s][e.t] = true;
			panel.set(edges);
		}
	}

	/**
	 * 一時的に辺を表現するためのクラス
	 * @author masayasu
	 */
	class Edge {
		int s;
		int t;
		public Edge(int s, int t) {
			this.s = s;
			this.t = t;
		}
		@Override
		public int hashCode() {
			return this.t;
		}
		@Override
		public boolean equals(Object obj) {
			if (obj instanceof Edge) {
				Edge edge = (Edge) obj;
				return edge.s == this.s && edge.t == this.t;
			}
			return false;
		}
	}

	@Override
	public String toString() {
		return "1-tree";
	}
}