package util;

import java.awt.Point;

/**
 * ヒューリスティック評価関数
 * @author ma38su
 *
 */
public interface HeuristicEstimate {

	/**
	 * 頂点間のヒューリスティック評価値を求める
	 * @param n1 頂点
	 * @param n2 頂点
	 * @return 頂点間の距離のヒューリスティック評価値
	 */
	public double get(Point n1, Point n2);
}
