package control.move;

import java.util.Random;

import util.Log;
import view.Field;
import model.Cast;

/**
 * A*によって追跡を行うアルゴリズム
 * @author Masayasu Fujiwara
 */
public class AstarTrackingMove implements InteligentMove {
	private final Field field;
	private final Random generator;
	
	public AstarTrackingMove(Field field) {
		this.generator = new Random();
		this.field = field;
	}
	
	public boolean run(Cast predator) {
		int direction = predator.getDirection();
		if (predator.isMove()) {
			if (direction > 0) {
				if (direction == Cast.LEFT) {
					predator.moveLeft();
					return true;
				} else if (direction == Cast.RIGHT) {
					predator.moveRight();
					return true;
				}
			} else if (direction < 0) {
				if (direction == Cast.UP) {
					predator.moveUp();
					return true;
				} else if (direction == Cast.DOWN) {
					predator.moveDown();
					return true;
				}
			}
		}
		if (direction < 0) {
			int predatorX = this.field.getCastX(predator);
			int preyX = this.field.getPreyX();
			if (predatorX == preyX) {
				int predatorY = this.field.getCastY(predator);
				int preyY = this.field.getPreyY();
				if (direction == Cast.UP) {
					if (this.field.checkUp(predatorX, predatorY, preyY)) {
						Log.out(this, "prey found");
						predator.turnUp();
						predator.moveUp();
						return true;
					}
				} else if (direction == Cast.DOWN) {
					if (this.field.checkDown(predatorX, predatorY, preyY)) {
						Log.out(this, "prey found");
						predator.turnDown();
						predator.moveDown();
						return true;
					}
				}
			}
		} else if (direction > 0){
			int predatorY = this.field.getCastY(predator);
			int preyY = this.field.getPreyY();
			if (predatorY == preyY) {
				int predatorX = this.field.getCastX(predator);
				int preyX = this.field.getPreyX();
				if (direction == Cast.RIGHT) {
					if (this.field.checkRight(predatorY, predatorX, preyX)) {
						Log.out(this, "prey found");
						predator.turnRight();
						predator.moveRight();
						return true;
					}
				} else if (direction == Cast.LEFT) {
					if (this.field.checkLeft(predatorY, predatorX, preyX)) {
						Log.out(this, "prey found");
						predator.turnLeft();
						predator.moveLeft();
						return true;
					}
				}
			}
		}
		Log.out(this, "enemy turn");
		for (int i = 0; i < 5; i++) {
			switch (this.generator.nextInt(4)) {
				case 0 :
					if (this.field.checkRight(predator)) {
						predator.turnRight();
						predator.moveRight();
						return true;
					}
					break;
				case 1 :
					if (this.field.checkLeft(predator)) {
						predator.turnLeft();
						predator.moveLeft();
						return true;
					}
					break;
				case 2 :
					if (this.field.checkDown(predator)) {
						predator.turnDown();
						predator.moveDown();
						return true;
					}
					break;
				case 3 :
					if (this.field.checkUp(predator)) {
						predator.turnUp();
						predator.moveUp();
						return true;
					}
					break;
			}
		}
		return false;
	}
}
