import java.awt.BorderLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

import model.Cast;
import view.Field;
import control.Controller;

/**
 * AI Technique on Tile Field
 * @author Masayasu Fujiwara
 */
public class Main {
	public static void main(String[] args) throws IOException {
		JFrame frame = new JFrame("Field");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		Field field = new Field(19);
		Cast prey = new Cast("prey");
		Collection<Cast> predators = new ArrayList<Cast>();
		predators.add(new Cast("predator"));
		predators.add(new Cast("predator"));
		field.addPlayer(prey);
		field.addEnemy(predators);
		Controller controller = new Controller(field, prey, predators);

		JMenuBar menubar = new JMenuBar();
		JMenu menu1 = new JMenu("フィールド");
		menubar.add(menu1);
		ButtonGroup group1 = new ButtonGroup();
		
		JCheckBoxMenuItem menu1_1 = new JCheckBoxMenuItem("障害なし", true);
		menu1_1.setActionCommand("field_delete");
		menu1_1.addActionListener(controller);
		menu1.add(menu1_1);
		group1.add(menu1_1);
		
		JCheckBoxMenuItem menu1_2 = new JCheckBoxMenuItem("ボンバーマン風");
		menu1_2.setActionCommand("field_bomb");
		menu1_2.addActionListener(controller);
		menu1.add(menu1_2);
		group1.add(menu1_2);

		JCheckBoxMenuItem menu1_3 = new JCheckBoxMenuItem("迷路");
		menu1_3.setActionCommand("field_maze");
		menu1_3.addActionListener(controller);
		menu1.add(menu1_3);
		group1.add(menu1_3);
		
		JMenu menu2 = new JMenu("Predator");
		menubar.add(menu2);
		ButtonGroup group2 = new ButtonGroup();

		JCheckBoxMenuItem menu2_1 = new JCheckBoxMenuItem("ランダム", true);
		menu2_1.setActionCommand("ai_random");
		menu2_1.addActionListener(controller);
		menu2.add(menu2_1);
		group2.add(menu2_1);

		JCheckBoxMenuItem menu2_2 = new JCheckBoxMenuItem("単純な追跡");
		menu2_2.setActionCommand("ai_simple_tracking");
		menu2_2.addActionListener(controller);
		menu2.add(menu2_2);
		group2.add(menu2_2);

		JCheckBoxMenuItem menu2_3 = new JCheckBoxMenuItem("追跡");
		menu2_3.setActionCommand("ai_tracking");
		menu2_3.addActionListener(controller);
		menu2.add(menu2_3);
		group2.add(menu2_3);

		JCheckBoxMenuItem menu2_4 = new JCheckBoxMenuItem("逃避");
		menu2_4.setActionCommand("ai_runout");
		menu2_4.addActionListener(controller);
		menu2.add(menu2_4);
		group2.add(menu2_4);

		
		JCheckBoxMenuItem menu2_5 = new JCheckBoxMenuItem("目視追跡");
		menu2_5.setActionCommand("ai_viewtrack");
		menu2_5.addActionListener(controller);
		menu2.add(menu2_5);
		group2.add(menu2_5);

		frame.add(menubar, BorderLayout.NORTH);

		frame.addKeyListener(controller);
		frame.add(field);
		frame.setSize(500, 500);
		frame.setVisible(true);
		field.init();
		controller.run();
	}
}
