<?php
require_once('sonots.class.php');
require_once('metapage.class.php');

/**
 * Page List Class
 *
 * @package    PluginSonots
 * @license    http://www.gnu.org/licenses/gpl.html GPL v2
 * @author     sonots <http://lsx.sourceforge.jp/>
 * @version    $Id: pagelist.class.php,v 1.1 2008-06-07 07:23:17Z sonots $
 * @require    sonots    v 1.9
 * @require    metapage  v 1.4
 */

class PluginSonotsPagelist
{
    /**
     * array of metapages
     *
     * @var array
     */
    var $metapages = array();

    /**
     * constructor
     *
     * @param array $pages
     * @uses PluginSonotsMetapage
     */
    function PluginSonotsPagelist($pages)
    {
        foreach ($pages as $page) {
            $this->metapages[] = new PluginSonotsMetapage($page);
        }
    }

    /**
     * Get the specified meta informations of pages
     *
     * @param string $metakey specify meta information you want to get
     * @return array metas
     */
    function get_metas($metakey)
    {
        return sonots::get_members($this->metapages, $metakey);
    }

    /**
     * Set the specified meta infomration to pages
     *
     * @param string $metakey specify meta information you want to set
     * @param array $args if arguments required to set meta information
     */
    function set_metas($metakey, $args = array())
    {
        switch ($metakey) {
        case 'leaf': // tree can't be constructed item by item
            $leafs = PluginSonotsPagelist::get_tree(get_existpages());
            foreach ($this->metapages as $i => $val) {
                $page = $this->metapages[$i]->page;
                $this->metapages[$i]->leaf = $leafs[$page];
            }
            break;
        default:     // others can be
            $metapages = &$this->metapages;
            foreach ($metapages as $i => $val) {
                call_user_func_array(array(&$metapages[$i], 'set_' . $metakey), $args);
            }
            break;
        }
    }

    /**
     * Pad non existing dir nodes to construct hierarchical tree
     *
     * Example)
     *  A       A
     *  A/A =>  A/A
     *  B/B     B(non exist)
     *          B/B
     *
     * @param string $prefix current path
     */
    function pad_dirnodes($prefix, $sort)
    {
        $prefix = sonots::get_dirname($prefix) . '/';
        $size = count($this->metapages);
        $paths = $this->get_metas('relname');
        foreach ($paths as $i => $path) {
            $currpath = $path;
            while (TRUE) {
                if ($currpath == '') break;
                // if parent dir does not exist, pad
                if (($j = array_search($currpath, $paths)) === FALSE) {
                    $abspath = $prefix . $currpath;
                    $new = new PluginSonotsMetapage($abspath);
                    $new->reading   = $abspath;
                    $new->relname   = $currpath;
                    $new->depth     = substr_count($currpath, '/') + 1;
                    $new->timestamp = 1;
                    $new->date      = '';
                    $new->leaf      = FALSE;
                    $new->exist     = FALSE;
                    $this->metapages[] = $new;
                    $paths[]        = $currpath;
                }
                $currpath = sonots::get_dirname($currpath);
            }
        }
        if (count($this->metapages) > $size) {
            $this->sort_by($sort);
        }
    }

    /**
     * Slice metapages
     *
     * @param int $offset
     * @param mixed $length int or NULL (means forever)
     * @see array_slice
     */
    function slice($offset, $length)
    {
        $this->metapages = sonots::array_slice
            ($this->metapages, $offset, $length, true);
    }

    /**
     * sort metapages by a meta
     *
     * @param string $meta meta name
     */
    function sort_by($meta)
    {
        switch ($meta) {
        case 'name':
            $relnames = $this->get_metas('relname');
            asort($relnames, SORT_STRING);
            sonots::array_asort_key($this->metapages, $relnames);
            break;
        case 'date':
            $timestamps = $this->get_metas('timestamp');
            arsort($timestamps, SORT_NUMERIC);
            sonots::array_asort_key($this->metapages, $timestamps);
            break;
        case 'reading':
            $readings = $this->get_metas('reading');
            asort($readings, SORT_STRING);
            sonots::array_asort_key($this->metapages, $readings);
            break;
        case 'popular':
            $populars = $this->get_metas('popular');
            arsort($populars, SORT_NUMERIC);
            sonots::array_asort_key($this->metapages, $populars);
            break;
        default:
            $metas = $this->get_metas($meta);
            natcasesort($metas);
            sonots::array_asort_key($this->metapages, $metas);
            break;
        }
    }

    /**
     * Grep out metapages by speific fields
     *
     * @param string $meta name of meta information to be greped
     * @param string $func func name
     *  - preg     : grep by preg
     *  - ereg     : grep by ereg
     *  - mb_ereg  : grep by mb_ereg
     *  - prefix   : remains if prefix matches (strpos)
     *  - mb_prefix: (mb_strpos)
     *  - eq       : remains if equality holds
     *  - ge       : remains if greater or equal to
     *  - le       : remains if less or equal to
     * @param mixed $pattern
     * @param boolean $inverse grep -v
     * @return void
     */
    function grep_by($meta, $func, $pattern, $inverse = FALSE)
    {
        $metas = $this->get_metas($meta);
        $metas = sonots::grep_array($pattern, $metas, $func);
        if (! $inverse) {
            $this->metapages = array_intersect_key($this->metapages, $metas);
        } else {
            $this->metapages = array_diff_key($this->metapages, $metas);
        }
    }

    /**
     * Get HTML of page list
     *
     * @param string $cssclass css class
     * @return string list html
     */
    function display_pages($cssclass = '')
    {
        $items = $this->get_metas('link');
        $levels = $this->get_metas('depth');
        $extras  = $this->get_metas('info');
        foreach ($items as $i => $html) {
            $items[$i] .= ($extras[$i] != '') ? ' ' . $extras[$i] : '';
        }
        return sonots::display_list($items, $levels, $cssclass);
    }

    ///////////// static functions /////////
    /**
     * Prev Next Navigation
     *
     * @access static, public
     * @param array $interval array($offset, $length) current showing interval
     * @param string $basehref base href
     * @param string $cssclass
     * @return html
     * @uses get_prevnext
     */
    function display_navi($interval, $entire, $basehref, $cssclass = '')
    {
        list($prev, $next) = PluginSonotsPagelist::get_prevnext($interval);
        $prevlink = '';
        if ($prev[1] >= $entire[0]) {
            $prevhref = $basehref . '&amp;num=' . $prev[0] . ':' . $prev[1];
            $prevlink = '<span class="prev" style="float:left;"><a href="' . $prevhref . '">' . _('Prev ') . $length . '</a></span>';
        }
        $nextlink = '';
        if ($next[0] <= $entire[1]) {
            $nexthref = $basehref . '&amp;num=' . $next[0] . ':' . $next[1];
            $nextlink = '<span class="next" style="float:right;"><a href="' . $nexthref . '">' . _('Next ') . $length . '</a></span>';
        }
        return '<div class="' . $cssclass . '">' . $prevlink . $nextlink . '</div><div style="clear:both;"></div>';
    }

    /**
     * Get prev next intervals
     *
     * Example)
     * <code>
     *  $current = array(3, 10); // 3rd to 10th
     *  list($prev, $next) = get_prevnext($current);
     *  // array(-5, 2), array(11, 18)
     *  $entire = array(1, 100);
     *  list($prev, $next) = get_prevnext($current, $entire);
     *  // array(1, 2), array(11, 18)
     * </code>
     *
     * @access static, private
     * @param array $current
     * @param array $entire use if you want to assure entire interval
     * @return array array($prev, $next)
     */
    function get_prevnext($current, $entire = array(NULL, NULL))
    {
        $diff = $current[1] - $current[0];
        $next = array($current[1] + 1, $current[1] + 1 + $diff);
        $prev = array($current[0] - 1 - $diff, $current[0] - 1);
        if (! is_null($entire[0])) {
            $prev[0] = ($prev[0] < $entire[0]) ? $entire[0] : $prev[0];
            $prev[1] = ($prev[1] < $entire[0]) ? $entire[0] : $prev[1];
            $next[0] = ($next[0] < $entire[0]) ? $entire[0] : $next[0];
            $next[1] = ($next[1] < $entire[0]) ? $entire[0] : $next[1];
        }
        if (! is_null($entire[1])) {
            $prev[0] = ($prev[0] > $entire[1]) ? $entire[1] : $prev[0];
            $prev[1] = ($prev[1] > $entire[1]) ? $entire[1] : $prev[1];
            $next[0] = ($next[0] > $entire[1]) ? $entire[1] : $next[0];
            $next[1] = ($next[1] > $entire[1]) ? $entire[1] : $next[1];
        }
        return array($prev, $next);
    }

}

?>
