<?php
require_once('sonots/sonots.class.php');   // sonots' func collection
require_once('sonots/option.class.php');   // option parser func collection
require_once('sonots/pagelist.class.php'); // pagelist class
require_once('sonots/metapage.class.php'); // pagelist requires
require_once('sonots/tag.class.php');      // tag option
exist_plugin('new');                       // new option
exist_plugin('contentsy');                 // contents option
exist_plugin('includey');                  // include option
//error_reporting(E_ALL);

/**
 * Page List (ls) Plugin
 *
 * @package    plugin
 * @license    http://www.gnu.org/licenses/gpl.html GPL v2
 * @author     sonots <http://lsx.sourceforge.jp>
 * @link       http://lsy.sourceforge.jp/?Plugin%2Flsy.inc.php
 * @version    $Id: lsy.inc.php,v 2.0 2008-05-31 11:14:46 sonots $
 * @require    sonots/sonots     v 1.9
 * @require    sonots/option     v 1.4
 * @require    sonots/pagelist   v 1.1
 * @require    sonots/metapage   v 1.4
 * @require    sonots/tag
 * @require    contentsy
 * @require    includey
 */

class PluginLsy
{
    function PluginLsy()
    {
        // Configure options
        // array(type, default, config)
        static $conf_options = array(); if (empty($conf_options)) {
            $toc = new PluginContentsy();
            $include = new PluginIncludey();
            $conf_options = array(
            'hierarchy' => array('bool', true),
            'non_list'  => array('bool', true),
            'reverse'   => array('bool', false), 
            'basename'  => array('bool', false), // obsolete
            'sort'      => array('enum', 'name', array('name', 'reading', 'date')),
            'tree'      => array('enum', false, array(false, 'leaf', 'dir')),
            'depth'     => array('interval', ''),
            'num'       => array('interval', ''),
            'next'      => array('bool', false),
            'except'    => array('string', ''),
            'filter'    => array('string', ''),
            'prefix'    => array('string', ''),
            'contents'  => array('options', null, $toc->conf_options),
            'include'   => array('options', null, $include->conf_options),
            'info'      => array('enumarray', array(), array('date', 'new')),
            'date'      => array('bool', false), // will be obsolete
            'new'       => array('bool', false),
            'tag'       => array('string', ''),
            'linkstr'   => array('enum', 'relative', array('name', 'pagename', 'absolute', 'relname', 'relative', 'basename', 'title', 'headline')),
            'link'      => array('enum', 'page', array('page', 'anchor', 'off')),
            'newpage'   => array('enum', false, array('on', 'except')),
        );
        }
        $this->conf_options    = &$conf_options;

        if (extension_loaded('mbstring')) {
            mb_regex_encoding(SOURCE_ENCODING);
        }
    }
    
    // static
    var $conf_options;
    var $plugin = "lsy";
    // var

    function convert()
    {
        sonots::init_myerror(); do {
            $args = func_get_args();
            $line = csv_implode(',', $args);
            $options = PluginSonotsOption::parse_option_line($line);
            list($options, $unknowns) = PluginSonotsOption::evaluate_options($options, $this->conf_options);
            $options = PluginLsy::check_options($options, $unknowns, $this->conf_options);
            if (sonots::mycatch()) break;

            if ($options['tag'] !== '') {
                $tag = new PluginSonotsTag();
                $pages = $tag->get_taggedpages($options['tag']);
            } else {
                $pages = get_existpages();
            }
            $html = PluginLsy::pagelist($pages, $options, $this->conf_options);
            return $html;
        } while (false);
        if (sonots::mycatch()) {
            return '<p>#lsy(): ' . sonots::mycatch() . '</p>';
        }
    }

    function action()
    {
        sonots::init_myerror(); do {
            global $vars;
            $options = $vars;
            list($options, $unknowns) = PluginSonotsOption::evaluate_options($options, $this->conf_options);
            $options = PluginLsy::check_options($options, array(), $this->conf_options);
            if (sonots::mycatch()) break;

            if ($options['tag'] !== '') {
                $tag = new PluginSonotsTag();
                $pages = $tag->get_taggedpages($options['tag']);
                $title = htmlspecialchars($options['tag']);
            } else {
                $pages = get_existpages();
                if ($options['prefix'] !== '') {
                    $title = htmlspecialchars($options['prefix']);
                } else {
                    $title = $this->plugin;
                }
            }
            $html = PluginLsy::pagelist($pages, $options, $this->conf_options);
            return array('msg'=>$title, 'body'=>$html);
        } while(false);
        if (sonots::mycatch()) {
            return array('msg'=>$this->plugin, 'body'=>'<p>' . sonots::mycatch() . '</p>');
        }
    }

    function pagelist($pages, $options, $conf_options)
    {
        $pagelist = new PluginSonotsPagelist($pages);
        $mb = extension_loaded('mbstring') ? 'mb_' : '';

        if ($options['prefix'] !== '') {
            $pagelist->grep_by('page', $mb . 'prefix', $options['prefix']);
            $pagelist->set_metas('relname', array(sonots::get_dirname($options['prefix'])));
        }
        if ($options['non_list']) {
            $pattern = '/' . preg_quote($GLOBALS['non_list'], '/') . '/';
            $pagelist->grep_by('page', 'preg', $pattern, true); // inverse
        }
        if ($options['filter'] !== '') {
            $pagelist->grep_by('relname', $mb . 'ereg', $options['filter']);
        }
        if ($options['except'] !== '') {
            $pagelist->grep_by('relname', $mb . 'ereg', $options['except'], true); // inverse
        }
        switch ($options['newpage']) {
        case 'on':
            $pagelist->set_metas('newpage');
            $pagelist->grep_by('newpage', 'eq', true);
            break;
        case 'except':
            $pagelist->set_metas('newpage');
            $pagelist->grep_by('newpage', 'eq', false);
            break;
        default:
            break;
        }
        if ($options['depth'] !== '' || $options['hierarchy'] || $options['tree'] ) {
            $pagelist->set_metas('depth');
        }
        if ($options['depth'] !== '') {
            list($offset, $length) = $options['depth'];
            // do not use negative interval for depth
            list($min, $max) = PluginSonotsOption::conv_interval($offset, $length, 1, PHP_INT_MAX);
            $pagelist->grep_by('depth', 'ge', $min);
            $pagelist->grep_by('depth', 'le', $max);
        }
        switch ($options['tree']) {
        case 'leaf':
            $pagelist->set_metas('leaf');
            $pagelist->grep_by('leaf', 'eq', true);
            break;
        case 'dir':
            $pagelist->set_metas('leaf');
            $pagelist->grep_by('leaf', 'eq', false);
            break;
        default:
            break;
        }
        if ($options['date'] || $options['new'] || $options['sort'] === 'date') {
            $pagelist->set_metas('timestamp');
        }
        
        $pagelist->sort_by($options['sort']);

        if (is_array($options['num'])) {
            list($offset, $length) = $options['num'];
            $pagelist->slice($offset, $length);
        }

        //////// display include
        if (! is_null($options['include'])) {
            $pages = $pagelist->get_metas('page');
            $include = new PluginIncludey(); // just want static var
            $includes = array();
            foreach ($pages as $i => $page) {
                $includes[$i] = PluginIncludey::include_page($page, $options['include'], $include->syntax);
            }
            $html = implode("\n", $includes);
            return $html;
        }

        //////// display list
        if ($options['hierarchy']) {
            $pagelist->pad_dirnodes($options['prefix'], $options['sort']);
        }

        $pagelist->set_metas('link', array($options['linkstr'], $options['link']));
        $links = $pagelist->get_metas('link');

        $infos = array();
        if (! empty($options['info'])) {
            $pagelist->set_metas('info', array($options['info']));
            $infos = $pagelist->get_metas('info');
        }

        $tocs = array();
        if (! is_null($options['contents'])) {
            $pages = $pagelist->get_metas('page');
            foreach ($pages as $i => $page) {
                $tocs[$i] = PluginContentsy::toc($page, $options['contents']);
            }
        }

        $items = array();
        foreach ($links as $i => $link) {
            $items[$i] = $links[$i];
            if (isset($infos[$i])) $items[$i] .= ' ' . $infos[$i];
            if (isset($tocs[$i])) $items[$i] .= $tocs[$i];
        }
        $levels = $pagelist->get_metas('depth');
        $html = sonots::display_list($items, $levels, 'lsy');

        // prev next
        if ($options['next'] && $options['num'] !== '') {
            $basehref = get_script_uri() . '?cmd=lsy';
            foreach ($options as $key => $val) {
                // add only user-input (non-default) option values
                if ($conf_options[$key][1] != $val) {
                    $basehref .= '&' . rawurlencode($key) 
                        . '='. rawurlencode(sonots::array_to_string((array)$val));
                }
            }
            $basehref = htmlspecialchars($basehref);
            list($offset, $length) = $options['num'];
            $entire   = array(1, count($pagelist->metapages));
            $interval = PluginSonotsOption::conv_interval($offset, $length, $entire[0], $entire[1]);
            $html .= $pagelist->display_navi($interval, $entire, $basehref, 'lsy');
        }
        return $html;
    }
    

    function check_options($options, $unknowns, $conf_options)
    {
        global $vars;

        //// prefix
        if ($options['prefix'] == '' && count($unknowns) > 0) {
            $unknown_keys = array_diff_key($unknowns, $conf_options);
            $options['prefix'] = $key = key($unknown_keys); // compat with ls, ls2
            unset($unknowns[$key]);
        }
        if (count($unknowns) > 0) {
          $line = PluginSonotsOption::glue_option_line($unknowns);
          sonots::mythrow('Argument(s) "' . htmlspecialchars($line) . '" are invalid');
          return;
        }
        if ($options['prefix'] == '') {
            if ($options['tag'] == '') {
                $options['prefix'] = $vars['page'] != '' ? $vars['page'] . '/' : '';
            }
        } elseif ($options['prefix'] == '/') {
            $options['prefix'] = '';
        } else {
            $options['prefix'] = sonots::get_fullname($options['prefix'], $vars['page']);
        }

        //// hierarchy off
        if ($options['tag'] != '') {
            $options['hierarchy'] = false;
        }
        if ($options['sort'] == 'date') {
            $options['hierarchy'] = false;
        }
        if (! is_null($options['include'])) {
            $options['include'] = PluginIncludey::check_options($options['include']);
            $options['hierarchy'] = false; // hierarchy + include => XHTML invalid
            $options['date'] = false;      // include does not use definitely
            $options['new']  = false;      // include does not use definitely
            $options['contents'] = null;     // include does not use definitely
        }
        if (! is_null($options['contents'])) {
            $options['contents'] = PluginContentsy::check_options($options['contents'], $unknowns['contents']);
            $options['contents']['fromhere'] = false;
            $options['contents']['link'] = 'page';
        }

        if ($options['linkstr'] === 'relative' && $options['hierarchy']) {
            $options['linkstr'] = 'basename'; // equivalent to basename
        }

        //// Compat
        if ($options['basename'] === true) {
            $options['linkstr'] = 'basename'; 
        }

        if ($options['date']) {
            if (! in_array('date', $options['info'])) {
                $options['info'][] = 'date';
            }
        }
        if ($options['new']) {
            if (! in_array('new', $options['info'])) {
                $options['info'][] = 'new';
            }
        }
        return $options;
    }

}

///////////////////////////////////////////
function plugin_lsy_init()
{
    global $plugin_lsy_name;
    if (class_exists('PluginLsyUnitTest')) {
        $plugin_lsy_name = 'PluginLsyUnitTest';
    } elseif (class_exists('PluginLsyUser')) {
        $plugin_lsy_name = 'PluginLsyUser';
    } else {
        $plugin_lsy_name = 'PluginLsy';
    }
}
function plugin_lsy_action()
{
    global $plugin_lsy, $plugin_lsy_name;
    $plugin_lsy = new $plugin_lsy_name();
    return call_user_func(array(&$plugin_lsy, 'action'));
}
function plugin_lsy_convert()
{
    global $plugin_lsy, $plugin_lsy_name;
    $plugin_lsy = new $plugin_lsy_name();
    $args = func_get_args();
    return call_user_func_array(array(&$plugin_lsy, 'convert'), $args);
}

if (! defined('INIT_DIR')) // if not Plus! 
    if (file_exists(DATA_HOME . 'init/lsy.ini.php')) 
        include_once(DATA_HOME . 'init/lsy.ini.php');

?>
