package org.minimalistbattery.impl.modelizer;

import java.util.Enumeration;
import java.util.Hashtable;

import org.lixm.optional.v11.namespace.NamespaceBinding;

/**
 * <p>名前空間バインディングの最小限の実装です。</p>
 * 
 * @author tasogare
 *
 */
public class MinimalistNamespaceBinding implements NamespaceBinding {

    private Hashtable uris;
    private Hashtable prefixs;

    public MinimalistNamespaceBinding() {
	uris = new Hashtable();
	prefixs = new Hashtable();
    }

    public String getNamespaceURI(Object prefix){
	return (String)uris.get(prefix);
    }

    public Object getPrefix(String namespaceURI){
	return prefixs.get(namespaceURI);
    }

    public Object[] getPrefixes(String namespaceURI){

	Enumeration prefixEnum = prefixs.elements();
	Object[] prefixObujects = new Object[prefixs.size()];
	int i=0;
	while (prefixEnum.hasMoreElements()) {
	    prefixObujects[0] = prefixEnum.nextElement();
	    i++;
	}
	return prefixObujects;
    }

    public Object put(Object prefix, String namespaceURI){

	String prefixString = (prefix==null) ? "" : (String) prefix;

	Object prefixObject = prefixs.get(namespaceURI);
	uris.put(prefixString, namespaceURI);
	prefixs.put(namespaceURI, prefixString);
	return (prefixObject != null) ? prefixObject : null;
    }

    public Object remove(Object key){
	String namespaceURI = (String)uris.get(key);
	uris.remove(key);
	Object prefix = prefixs.remove(namespaceURI);
	return prefix;
    }
}
