package org.pigeonblood.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;

import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLType;
import org.lixm.core.model.AbstractModel;
import org.pigeonblood.impl.core.list.SimpleDocumentList;
import org.pigeonblood.impl.core.modelizer.TreeXMLModelizer;
import org.xml.sax.SAXException;


public class Test2 {


    private static final int RUNTIME_ERR_CODE = 1;

    private static File inputXML;
    private static DocumentBuilderFactory builderFactory;
    private static DocumentBuilder builder;
    private static DOMSource srcXML;

    private static TreeXMLModelizer modelizer;

    /*
     * p[T̐ݒOvpeBt@C
     */
    private static Properties xmlConf;

    /**
     * @param args
     */
    public static void main(
        String[] args)
    {
        if (!analizeArgs(args)) {
            cryErr( );
        }

        createSource( );

        if (srcXML == null) {
            cryErr( );
        }

        createModelizer( );

        printXMLList( );
    }

    /**
     * s̉
     * @param args
     * @return s̉͂ɐǂ
     */
    protected static synchronized boolean analizeArgs(
        String[] args)
    {

        boolean resualt = false;
        if (args.length != 2) {
            usage( );
            resualt = false;
        } else {
            inputXML = new File(args[0]);

            if (analizeProperties(args[1])) {
                resualt = true;
            } else {
                resualt = false;
            }
        }

        return resualt;
    }


    protected static void parserConfiguration() {
        if (builder == null) {
            throw new AssertionError("SAXp[T null łB");
        }

        if (modelizer == null) {
            throw new AssertionError("fCU null łB");
        }


        printMessages(
            "", "DOM̋@\",
            "+\t\t\t\t\t\t\t\t\t\t+",
            "OԂ̔F : " + builder.isNamespaceAware( ),
            "Ó؂̗L : " + builder.isValidating( ),
            "+\t\t\t\t\t\t\t\t\t\t+", "");
    }

    protected final static void usage() {
        System.out.println("Usage:");
        System.out.println("\t\tjava Test input_xml_file xml_config_file");
    }

    private static synchronized boolean analizeProperties(
        String fileName)
    {

        boolean resualt = false;
        if (fileName.endsWith(".properties")) {
            xmlConf = new Properties( );

            try {
                xmlConf.load(new FileReader(fileName));
            } catch (FileNotFoundException e) {
                System.err.println("vpeBt@C܂B");
                usage( );
                resualt = false;
                return resualt;
            } catch (IOException e) {
                System.err.println("vpeBt@C̓ǂݍ݂Ɏs܂B");
                usage( );
                resualt = false;
                return resualt;
            }

            resualt = true;
        } else {
            resualt = false;
            System.err.println("vpeBt@C̊gq 'properties' łȂ΂܂B");
            usage( );
        }

        return resualt;
    }

    private static synchronized void createModelizer() {
        modelizer = (TreeXMLModelizer)TreeXMLModelizer.newInstance(srcXML,
            new SimpleDocumentList(10000));

        parserConfiguration( );
    }

    private static synchronized void createSource() {
        builderFactory = DocumentBuilderFactory.newInstance( );
        builderFactory.setNamespaceAware(true);
        builderFactory.setCoalescing(true);
        builderFactory.setIgnoringElementContentWhitespace(false);

        try {
	        builder = builderFactory.newDocumentBuilder( );
        } catch ( ParserConfigurationException e1 ) {
	        e1.printStackTrace();
        }

         
        try {
            srcXML = new DOMSource(builder.parse(inputXML));
        } catch (FileNotFoundException e) {
            e.printStackTrace( );
        } catch (SAXException e) {
            e.printStackTrace( );
        } catch ( IOException e ) {
	        e.printStackTrace();
        }
    }

    private static void cryErr(
        String... messages)
    {

        for (String mess : messages) {
            System.err.println(mess);
        }

        System.err
            .println("--------------------------------------------------------------------------------");
        System.err.println( );
        System.err.println("vOsɃG[܂B");
        System.err.println("vOI܂B");
        System.err.println( );

        System.exit(RUNTIME_ERR_CODE);
    }

    private static void printMessages(
        Object... messages) throws IllegalArgumentException
    {
        if (messages == null || messages.length == 0) {
            throw new IllegalArgumentException(
                "ψ messages ͂PȏObject^łȂ΂܂B");
        }

        for (Object mess : messages) {
            System.out.println(mess);
        }
    }

    private static void printXMLList() {
        try {
            modelizer.modelize( );
        } catch (LIXMPhaseException e) {
            e.getException( ).printStackTrace( );
            e.printStackTrace( );
            cryErr(e.getMessage( ));
        }

        SimpleDocumentList list = (SimpleDocumentList) modelizer.getList( );

        if (list == null || list.size( ) == 0) {
            cryErr("fXgłB");
        }

        System.out.println("fXg̃TCY : " + String.valueOf(list.size( ) - 1));

        try {
            for (AbstractModel model : list) {
                if (!( model.matchTypes(XMLType.START_DOCUMENT) || model
                    .matchTypes(XMLType.END_DOCUMENT) ))
                {
                    System.out.print(model);
                } else {
                    printMessages("\n",
                        ( model.matchTypes(XMLType.START_DOCUMENT)
                        ? "̎n܂\n"
                        + "--------------------------------------------------------------------------------\n"
                        :  "--------------------------------------------------------------------------------\n"
                        + "̏I" ), "");
                }
            }
        } catch (RuntimeException e) {
            e.printStackTrace( );
        }
    }

}
